<?php
require("MySQLDAO.php");
$config = parse_ini_file('../config/config.ini');


$returnValue = array();

$dbhost = trim($config["dbhost"]);
$dbuser = trim($config["dbuser"]);
$dbpassword = trim($config["dbpassword"]);
$dbname = trim($config["dbname"]);
 

$dao = new MySQLDAO($dbhost, $dbuser, $dbpassword, $dbname);
$dao->openConnection();
 

$suppliers = $dao->getAllSuppliers();

$physical_conditions = $dao->getAllPhysicalConditions();

$packing_methods = $dao->getAllPackingMethods();
$vehicles = $dao->getAllVehicles();
$drivers =  $dao->getAllDrivers();


if( !empty($suppliers) && !empty($physical_conditions) && !empty($packing_methods) )
{
    $returnValue["suppliers"] = $suppliers;
    $returnValue["physical_conditions"] = $physical_conditions;
    $returnValue["packing_methods"] = $packing_methods;
    $returnValue["vehicles"] = $vehicles;
    $returnValue["drivers"] = $drivers;
} else {
    $returnValue["message"] = "Could not find any suppliers";
}

$dao->closeConnection();
 
echo json_encode($returnValue);
 
?>
