<?php

//sleep(5); 
 
class MySQLDAO
{

    var $dbhost = null;
    var $dbuser = null;
    var $dbpass = null;
    var $dbname = null;

	var $conn = null;
    var $result = null;

    function __construct($dbhost, $dbuser, $dbpassword, $dbname) {
        $this->dbhost = $dbhost;
        $this->dbuser = $dbuser;
        $this->dbpass = $dbpassword;
        $this->dbname = $dbname;
    }
    
    
    public function openConnection() {
        $this->conn = new mysqli($this->dbhost, $this->dbuser, $this->dbpass, $this->dbname);
        if (mysqli_connect_errno())
            throw new Exception("Could not establish connection with database");
        $this->conn->set_charset("utf8");
    }
    
    public function closeConnection() {
        if ($this->conn != null)
            $this->conn->close();
    }
    
    
    public function getUserDetails($email) {
        $returnValue = array();
        $sql = "select * from users where email='" . $email . "'";
        
        $result = $this->conn->query($sql);
        if ($result != null && (mysqli_num_rows($result) >= 1)) {
            $row = $result->fetch_array(MYSQLI_ASSOC);
            if (!empty($row)) {
                $returnValue = $row;
            }
        }
        return $returnValue;
    }   
    
     public function registerUser( $userFirstName , $userLastName , $userEmail  , $userPhone, $secured_password , $salt ,$image ,$isEmailConfirmed , $type )
     { 
        $sql = "insert into ila_users set  first_name=?, last_name =? ,email =? , mobile_number=?, user_password=? , salt=? , 
		         user_image=?, isEmailConfirmed=? , user_type=? ";
        $statement = $this->conn->prepare($sql);

        if (!$statement)
            throw new Exception($statement->error);
        $statement->bind_param("sssssssis", $userFirstName , $userLastName , $userEmail  , $userPhone, $secured_password , $salt ,$image ,$isEmailConfirmed , $type);
        $returnValue = $statement->execute();

        return $returnValue;  
    }   
    
    
     public function storeEmailToken($user_id, $email_token)
    { 
        $sql = "insert into ila_email_tokens set user_id=?, email_token=?";
        $statement = $this->conn->prepare($sql);

        if (!$statement)
            throw new Exception($statement->error);

        $statement->bind_param("is", $user_id, $email_token);
        $returnValue = $statement->execute();

        return $returnValue;  
    }
    
    
    function getUserIdWithToken($emailToken)
    {
        $returnValue = array();
        $sql = "select user_id from ila_email_tokens where email_token='" . $emailToken . "'";
  
        $result = $this->conn->query($sql);
        if ($result != null && (mysqli_num_rows($result) >= 1)) {
            $row = $result->fetch_array(MYSQLI_ASSOC);
            if (!empty($row)) {
                $returnValue = $row['user_id'];
            }
        }
        return $returnValue;  
        
    }
    

    function setEmailConfirmedStatus($status, $user_id)
    {
        $sql = "update ila_users set isEmailConfirmed=? where user_id=?";
        $statement = $this->conn->prepare($sql);
        if (!$statement)
            throw new Exception($statement->error);

        $statement->bind_param("ii", $status, $user_id);
        $returnValue = $statement->execute();  
        
        return $returnValue;
        
    }
   
   
    function deleteUsedToken($emailToken)
    {
        $sql = "delete from ila_email_tokens where email_token=?";
        $statement = $this->conn->prepare($sql);

        if (!$statement)
            throw new Exception($statement->error);

        $statement->bind_param("s", $emailToken);
        $returnValue = $statement->execute();  
        
        return $returnValue;
    }
    
	
  
    public function storePasswordToken($user_id, $token)
    {
        $sql = "insert into ila_password_tokens set user_id=?, password_token=?";
        $statement = $this->conn->prepare($sql);

        if (!$statement)
            throw new Exception($statement->error);

        $statement->bind_param("is", $user_id, $token);
        $returnValue = $statement->execute();
        
        return $returnValue;
        
    }
 
    
	
    function getUserIdWithPasswordToken($token)
    {
        $returnValue = null;
        $sql = "select user_id from ila_password_tokens where password_token='" . $token . "'";
  
        $result = $this->conn->query($sql);
        if ($result != null && (mysqli_num_rows($result) >= 1)) {
            $row = $result->fetch_array(MYSQLI_ASSOC);
            if (!empty($row)) {
                $returnValue = $row['user_id'];
            }
        }
        return $returnValue;  
    }
    
    function updateUserPassword($user_id,$secured_password,$salt)
    {
        $sql = "update ila_users set user_password=?, salt=? where user_id=?";
        $statement = $this->conn->prepare($sql);

        if (!$statement)
            throw new Exception($statement->error);

        $statement->bind_param("ssi", $secured_password, $salt, $user_id);
        $returnValue = $statement->execute();
        
        return $returnValue;    
    }
    
	
    function deleteUsedPasswordToken($token)
    {
        $sql = "delete from ila_password_tokens where password_token=?";
        $statement = $this->conn->prepare($sql);

        if (!$statement)
            throw new Exception($statement->error);

        $statement->bind_param("s", $token);
        $returnValue = $statement->execute();
        
        return $returnValue;  
    }
    
 ///////////////////////////////////////////////////////////////////////////////////////
 
 public function getTodayPrice() {
    $returnValue = array();
    $date = date('Y-m-d');
    $sql = "select * from prices where DATE ( created_at) ='" . $date . "'";
    $result = $this->conn->query($sql);
    if ($result != null && (mysqli_num_rows($result) >= 1)) {
        $row = $result->fetch_array(MYSQLI_ASSOC);
        if (!empty($row)) {
            $returnValue = $row;
        }
    }
    return $returnValue;
} 


public function getWasteById($waste_id) {
    $returnValue = array();
    $sql = "select * from waste where id=".$waste_id;
    
    $result = $this->conn->query($sql);
    if ($result != null && (mysqli_num_rows($result) >= 1)) {
        $row = $result->fetch_array(MYSQLI_ASSOC);
        if (!empty($row)) {
            $returnValue = $row;
        }
    }
    return $returnValue;
}


    public function addNewReport( $description, $report_type, $latitude , $longitude  , $report_date , $report_status , $user_id  )
     { 
        $sql = "insert into ila_reports  set description=?, report_type =? ,latitude =? , longitude=?, report_date=? , report_status=? , user_id=?";
        $statement = $this->conn->prepare($sql);

        if (!$statement)
            throw new Exception($statement->error);
        $statement->bind_param("ssddssi",$description, $report_type, $latitude , $longitude  , $report_date , $report_status , $user_id );
         $statement->execute();
		
        $returnValue = $statement->insert_id ;
		return $returnValue;  
      
    }
	
	public function AddReportImage( $reportid  , $image  , $count ){
	
	 	$sql = "insert into ila_report_images  set image=?, report_id =? ";
        $statement = $this->conn->prepare($sql);
        $count++ ; 
		$path = "http://locator.000webhostapp.com/back/back/uploads/".$reportid."_".$count.".PNG" ;
        if (!$statement)
            throw new Exception($statement->error);
        $statement->bind_param("si", $path ,  $reportid );
		
		$returnValue = $statement->execute();
		
		return $returnValue ;
	
	}
 
 public function getNumberOfImagesOfRrport( $reportid   ){
	 
        $returnValue = null;
		$count = 0; 
        $sql = "select * from ila_report_images where report_id='" . $reportid . "'";
       
	   $result = $this->conn->query($sql);
       $count  = mysqli_num_rows($result) ;
		
        return $count;  
    }
	
	
	
	public function getReportImagesByReportId( $reportid   ){
	
	    $returnValue = array();
        
        $sql = "select * from ila_report_images where report_id='" . $reportid . "'";
       
        $statement = $this->conn->prepare($sql);

        if (!$statement)
            throw new Exception($statement->error);

        $statement->execute();
       
        $result = $statement->get_result();
        
         while ($myrow = $result->fetch_assoc()) 
         {
           $returnValue[] = $myrow;
         }
         
        return $returnValue;
	
	}
///////////////////////////////////////////////////////////////////////////////////////
	public function getAllSuppliers ( $user_id ){
	 
        $returnValue = array();
         
         
        if ($user_id == 1 ) {
        $sql = "select id , name, CONCAT('https://egwaste.org/egwaste/public', `logo`)  as logo from suppliers where 1 ";
        }else {
        $sql = "select id , name, CONCAT('https://egwaste.org/egwaste/public', `logo`)  as logo from suppliers where id in ( select supplier_id from supervisor_supplier where user_id = $user_id )";
        }
         
         $statement = $this->conn->prepare($sql);

        if (!$statement)
            throw new Exception($statement->error);

        $statement->execute();
       
        $result = $statement->get_result();
        
         while ($myrow = $result->fetch_assoc()) 
         {
           $returnValue[] = $myrow;
         }
         
        return $returnValue;
    }
	 
    public function getWastesOfSupplier ( $supplier_id ){
	 
        $returnValue = array();
        
        $sql = "select id , name from waste where id in ( select waste_id from supplier_waste where supplier_id = '" . $supplier_id . "' )";

        $statement = $this->conn->prepare($sql);

        if (!$statement)
            throw new Exception($statement->error);

        $statement->execute();
       
        $result = $statement->get_result();
        
         while ($myrow = $result->fetch_assoc()) 
         {
           $returnValue[] = $myrow;
         }
         
        return $returnValue;
    }

    public function getAllPhysicalConditions (){
	 
        $returnValue = array();
        
        $sql = "select id , name from physicalconditions where 1";
       
        $statement = $this->conn->prepare($sql);

        if (!$statement)
            throw new Exception($statement->error);

        $statement->execute();
       
        $result = $statement->get_result();
        
         while ($myrow = $result->fetch_assoc()) 
         {
           $returnValue[] = $myrow;
         }
         
        return $returnValue;
    }

    public function getAllPackingMethods (){
	 
        $returnValue = array();
        
        $sql = "select id , name from packingmethods where 1";
       
        $statement = $this->conn->prepare($sql);

        if (!$statement)
            throw new Exception($statement->error);

        $statement->execute();
       
        $result = $statement->get_result();
        
         while ($myrow = $result->fetch_assoc()) 
         {
           $returnValue[] = $myrow;
         }
         
        return $returnValue;
    }

    public function getAllVehicles (){
	 
        $returnValue = array();
        
        $sql = "select id , vehicle_num as name from vehicles where 1";
       
        $statement = $this->conn->prepare($sql);

        if (!$statement)
            throw new Exception($statement->error);

        $statement->execute();
       
        $result = $statement->get_result();
        
         while ($myrow = $result->fetch_assoc()) 
         {
           $returnValue[] = $myrow;
         }
         
        return $returnValue;
    }

    public function getAllDrivers (){
	 
        $returnValue = array();
        
        $sql = "select id , name from drivers where 1";
       
        $statement = $this->conn->prepare($sql);

        if (!$statement)
            throw new Exception($statement->error);

        $statement->execute();
       
        $result = $statement->get_result();
        
         while ($myrow = $result->fetch_assoc()) 
         {
           $returnValue[] = $myrow;
         }
         
        return $returnValue;
    }

public function getAllBranches (){
	 
        $returnValue = array();
        
        $sql = "select id , name from branches where 1";
       
        $statement = $this->conn->prepare($sql);

        if (!$statement)
            throw new Exception($statement->error);

        $statement->execute();
       
        $result = $statement->get_result();
        
         while ($myrow = $result->fetch_assoc()) 
         {
           $returnValue[] = $myrow;
         }
         
        return $returnValue;
    }
    
    public function getAllMessages (){
	 
        $returnValue = array();
         
        $sql = "select * from messages where 1";
       
        $statement = $this->conn->prepare($sql);

        if (!$statement)
            throw new Exception($statement->error);

        $statement->execute();
       
        $result = $statement->get_result();
        
         while ($myrow = $result->fetch_assoc()) 
         {
           $returnValue[] = $myrow;
         }
         
        return $returnValue;
    }
    
    
    public function addNewWaste( $supplier_id, $waste_id , $packmethod_id , $physical_id , $vehicle_id , $driver_id  , $user_id , $branch_id , $quantity , $carta_price , $carta_tax , $created_at , $date )
    { 
       $sql = "insert into mains  set supplier_id=?, waste_id =? ,packingmethod_id =? , physicalcondition_id=?, vehicle_id=? , driver_id=? , user_id=? , branch_id=? , quantity=?, price=?, tax=?, created_at=?, date=?";
       $statement = $this->conn->prepare($sql);

       if (!$statement)
           throw new Exception($statement->error);
       $statement->bind_param( "iiiiiiiiissss",$supplier_id, $waste_id , $packmethod_id , $physical_id , $vehicle_id , $driver_id  , $user_id , $branch_id , $quantity , $carta_price , $carta_tax, $created_at, $date);
        $statement->execute();
       
       $returnValue = $statement->insert_id ;
       return $returnValue;  
     
   }
   
      
public function getSellStoreById($store_id ,$branch_id ) {
    $returnValue = array();
    $sql = "select * from store_branch where store_id=".$store_id." and branch_id=".$branch_id;
    
    $result = $this->conn->query($sql);
    if ($result != null && (mysqli_num_rows($result) >= 1)) {
        $row = $result->fetch_array(MYSQLI_ASSOC);
        if (!empty($row)) {
            $returnValue = $row;
        }
    }
    return $returnValue;
}

function updateMain_add_sell_store_id($main_id,$sell_store_id)
    {
        $sql = "update mains set sell_store_id=? where id=?";
        $statement = $this->conn->prepare($sql);

        if (!$statement)
            throw new Exception($statement->error);

        $statement->bind_param("ii", $sell_store_id, $main_id);
        $returnValue = $statement->execute();
        
        return $returnValue;    
    }

function update_sell_store($sell_store_id,$quantity)
    {
        $sql = "update store_branch set quantity=quantity+$quantity where id=?";
        $statement = $this->conn->prepare($sql);

        if (!$statement)
            throw new Exception($statement->error);

        $statement->bind_param("i", $sell_store_id);
        $returnValue = $statement->execute();
        
        return $returnValue;    
    }




public function add_sel_store_history( $quantity_before,$quantity_after , $added, $user_id, $sell_store_id, $desc  )
     { 
        $sql = "insert into store_history  set quantity_before=?, quantity_after=? ,main_id=? , user_id=?, sell_store_id=? , descreption=? ";
        $statement = $this->conn->prepare($sql);

        if (!$statement)
            throw new Exception($statement->error);
        $statement->bind_param("ddiiis",$quantity_before,$quantity_after , $added, $user_id, $sell_store_id, $desc );
         $statement->execute();
		
        $returnValue = $statement->insert_id ;
		return $returnValue;  
      
    }
 ///////////////////////////////////////////////////////////////////////////////////////
 
 
 
    public function searchFriends($searchWord)
    {
        $returnValue = array();
        
        $sql = "select * from friends where 1";
       
        if(!empty($searchWord))
        {
            $sql .= " and ( first_name like ? or last_name like ? )";
        }
  
        $statement = $this->conn->prepare($sql);

        if (!$statement)
            throw new Exception($statement->error);

        if(!empty($searchWord))
        {
          $searchWord = '%' . $searchWord . "%";
          $statement->bind_param("ss",  $searchWord , $searchWord);
        }
        
        $statement->execute();
       
        $result = $statement->get_result();
        
         while ($myrow = $result->fetch_assoc()) 
         {
           $returnValue[] = $myrow;
         }
         
        return $returnValue;
    } 
    
	
	
	

    function deleteFriendRecord($friend_token) 
    {
        $sql = "delete from friends where token=?";
        $statement = $this->conn->prepare($sql);

        if (!$statement)
            throw new Exception($statement->error);

        $statement->bind_param("s", $friend_token);
        $statement->execute();
        
        $returnValue = $statement->affected_rows;
        
        return $returnValue;  
    }
    
}

?>
