<?php
//sleep(5); 
 
class MySQLDAO
{

    var $dbhost = null;
    var $dbuser = null;
    var $dbpass = null;
    var $dbname = null;

	var $conn = null;
    var $result = null;

    function __construct($dbhost, $dbuser, $dbpassword, $dbname) {
        $this->dbhost = $dbhost;
        $this->dbuser = $dbuser;
        $this->dbpass = $dbpassword;
        $this->dbname = $dbname;
    }
    
    
    public function openConnection() {
        $this->conn = new mysqli($this->dbhost, $this->dbuser, $this->dbpass, $this->dbname);
        if (mysqli_connect_errno())
            throw new Exception("Could not establish connection with database");
        $this->conn->set_charset("utf8");
    }
    
    public function closeConnection() {
        if ($this->conn != null)
            $this->conn->close();
    }
   
    
 ///////////////////////////////////////////////////////////////////////////////////////
 
 public function getUserDetails($email) {
    $returnValue = array();
    $sql = "select * from users where email='" . $email . "'";
    
    $result = $this->conn->query($sql);
    if ($result != null && (mysqli_num_rows($result) >= 1)) {
        $row = $result->fetch_array(MYSQLI_ASSOC);
        if (!empty($row)) {
            $returnValue = $row;
        }
    }
    return $returnValue;
}
 
///////////////////////////////////////////////////////////////////////////////////////
	public function getNotApprovedTieTrusts (  ){
	 
        $returnValue = array();
         
        $sql = "select t.created_at , t.id , t.name , t.amount , us.name as 'admin_name' from  trusts  t join users us on us.id = t.user_id where approve='Waiting';";
         
         
         $statement = $this->conn->prepare($sql);

        if (!$statement)
            throw new Exception($statement->error);

        $statement->execute();
       
        $result = $statement->get_result();
        
         while ($myrow = $result->fetch_assoc()) 
         {
           $returnValue[] = $myrow;
         }
         
        return $returnValue;
    }
	
	public function getWaitingTieTrustsIncrementAmount (  ){
	 
        $returnValue = array();
         
        $sql = "select t.created_at , t.id , t.name , t.amount , 
        t.increment_amount ,  us.name as 'admin_name' from trusts  t join users us on us.id = t.user_id  where increment_approve='Waiting'";
         
         
         $statement = $this->conn->prepare($sql);

        if (!$statement)
            throw new Exception($statement->error);

        $statement->execute();
       
        $result = $statement->get_result();
        
         while ($myrow = $result->fetch_assoc()) 
         {
           $returnValue[] = $myrow;
         }
         
        return $returnValue;
    }
	 
	public function tie_Trust_Approve ($trust_id){
		
		
		$sql = "update trusts set approve='Approved' where id=?";
        $statement = $this->conn->prepare($sql);
        if (!$statement)
            throw new Exception($statement->error);

        $statement->bind_param("i", $trust_id);
        $returnValue = $statement->execute();  
        
        return $returnValue;
		
	}
	
	public function tie_Trust_Reject ($trust_id){
		
		
		$sql = "update trusts set approve='Rejected' where id=?";
        $statement = $this->conn->prepare($sql);
        if (!$statement)
            throw new Exception($statement->error);

        $statement->bind_param("i", $trust_id);
        $returnValue = $statement->execute();  
        
        return $returnValue;
		
	}
	
	
	public function tie_Trust_Increment_Approve ($trust_id , $new_amount){
		
		
		$sql = "update trusts set increment_approve='Approved' , increment_amount=0 , amount=? where id=?";
        $statement = $this->conn->prepare($sql);
        if (!$statement)
            throw new Exception($statement->error);

        $statement->bind_param("ii", $new_amount,$trust_id);
        $returnValue = $statement->execute();  
        
        return $returnValue;
		
	}
	
	public function tie_Trust_Increment_Reject ($trust_id , $new_amount){
		
		
		$sql = "update trusts set increment_approve='Rejected' where id=?";
        $statement = $this->conn->prepare($sql);
        if (!$statement)
            throw new Exception($statement->error);

        $statement->bind_param("i", $trust_id);
        $returnValue = $statement->execute();  
        
        return $returnValue;
		
	}
	
   
  
 
 public function getWaitingPaymentVouchers_General (  ){
	 
        $returnValue = array();
         
        //$sql = "SELECT id , pay, type , general_name , note1,note2 FROM payment_vouchers pv WHERE pv.approve='Waiting' && pv.type='سند صرف عام'";
         $sql="SELECT pv.created_at ,pv.id , pay, type , general_name , note1,note2 , br.name as 'branch', pm.name as 'payment_method' ,sa.balance ,us.name as 'admin_name' FROM payment_vouchers pv join safe_accounts sa on sa.id = pv.safe_account_id join branches br on br.id = sa.branch_id join payment_methods pm on pm.id = sa.payment_method_id join users us on us.id = pv.user_id WHERE pv.approve='Waiting'   && pv.type='سند صرف عام';";
         
         $statement = $this->conn->prepare($sql);

        if (!$statement)
            throw new Exception($statement->error);

        $statement->execute();
       
        $result = $statement->get_result();
        
         while ($myrow = $result->fetch_assoc()) 
         {
           $returnValue[] = $myrow;
         }
         
        return $returnValue;
    }
 
 
 public function getWaitingPaymentVouchers_Employees (  ){
	 
        $returnValue = array();
         
       // $sql = "SELECT pv.id , pay, type , note1,note2,e.name FROM payment_vouchers pv JOIN employee e ON pv.employee_id=e.id WHERE pv.approve='Waiting' && pv.type='سند صرف موظفين'";
         $sql = "SELECT pv.created_at , pv.id , pay, pv.type , note1,note2,e.name , br.name as 'branch', pm.name as 'payment_method' ,sa.balance ,us.name as 'admin_name' FROM payment_vouchers pv JOIN employee e ON pv.employee_id=e.id join safe_accounts sa on sa.id = pv.safe_account_id join branches br on br.id = sa.branch_id join payment_methods pm on pm.id = sa.payment_method_id join users us on us.id = pv.user_id WHERE pv.approve='Waiting' && pv.type='سند صرف موظفين'";
         
         $statement = $this->conn->prepare($sql);

        if (!$statement)
            throw new Exception($statement->error);

        $statement->execute();
       
        $result = $statement->get_result();
        
         while ($myrow = $result->fetch_assoc()) 
         {
           $returnValue[] = $myrow;
         }
         
        return $returnValue;
    }
 

 public function getWaitingPaymentVouchers_Budgets (  ){
	 
        $returnValue = array();
         
        //$sql = "SELECT pv.id , pay,general_name, type, note2 , b.name FROM payment_vouchers pv JOIN budgets b ON pv.budget_id=b.id WHERE pv.approve='Waiting' && pv.type='سند صرف ميزانية'";
         $sql= "SELECT pv.created_at , pv.id , pay,general_name, type, note2 , b.name , br.name as 'branch', pm.name as 'payment_method' ,sa.balance ,us.name as 'admin_name' FROM payment_vouchers pv JOIN budgets b ON pv.budget_id=b.id join safe_accounts sa on sa.id = pv.safe_account_id join branches br on br.id = sa.branch_id join payment_methods pm on pm.id = sa.payment_method_id join users us on us.id = pv.user_id WHERE pv.approve='Waiting' && pv.type='سند صرف ميزانية';";
         
         $statement = $this->conn->prepare($sql);

        if (!$statement)
            throw new Exception($statement->error);

        $statement->execute();
       
        $result = $statement->get_result();
        
         while ($myrow = $result->fetch_assoc()) 
         {
           $returnValue[] = $myrow;
         }
         
        return $returnValue;
    }


public function getWaitingPaymentVouchers_Cars (  ){
	 
        $returnValue = array();
         
       // $sql = "SELECT pv.id , pay,general_name, pv.type, note2 , c.num,ce.name FROM payment_vouchers pv JOIN cars c ON pv.car_id=c.id JOIN car_expenses ce ON pv.car_expense_id=ce.id WHERE pv.approve='Waiting' && pv.type='سند صرف سيارات';";
         $sql = "SELECT pv.created_at , pv.id , pay,general_name, pv.type, note2 , c.num,ce.name , br.name as 'branch', pm.name as 'payment_method' ,sa.balance ,us.name as 'admin_name' FROM payment_vouchers pv JOIN cars c ON pv.car_id=c.id JOIN car_expenses ce ON pv.car_expense_id=ce.id join safe_accounts sa on sa.id = pv.safe_account_id join branches br on br.id = sa.branch_id join payment_methods pm on pm.id = sa.payment_method_id join users us on us.id = pv.user_id  WHERE pv.approve='Waiting' && pv.type='سند صرف سيارات';";
         
         $statement = $this->conn->prepare($sql);

        if (!$statement)
            throw new Exception($statement->error);

        $statement->execute();
       
        $result = $statement->get_result();
        
         while ($myrow = $result->fetch_assoc()) 
         {
           $returnValue[] = $myrow;
         }
         
        return $returnValue;
    }


public function getWaitingPaymentVouchers_TrustNotTie (  ){
	 
        $returnValue = array();
         
        //$sql = "SELECT pv.id , pay,general_name, pv.type, note2 ,t.name as 'trust_name', e.name FROM payment_vouchers pv JOIN trusts t ON pv.trust_id=t.id JOIN employee e ON pv.employee_id=e.id WHERE pv.approve='Waiting' && pv.type='سند صرف عهدة غير مربوطة بمبلغ';";
         $sql = "SELECT pv.created_at , pv.id , pay,general_name, pv.type, note2 ,t.name as 'trust_name',  br.name as 'branch', pm.name as 'payment_method' ,sa.balance ,us.name as 'admin_name' FROM payment_vouchers pv JOIN trusts t ON pv.trust_id=t.id  join safe_accounts sa on sa.id = pv.safe_account_id join branches br on br.id = sa.branch_id join payment_methods pm on pm.id = sa.payment_method_id join users us on us.id = pv.user_id WHERE pv.approve='Waiting' && pv.type='سند صرف عهدة غير مربوطة بمبلغ';";
         
         $statement = $this->conn->prepare($sql);

        if (!$statement)
            throw new Exception($statement->error);

        $statement->execute();
       
        $result = $statement->get_result();
        
         while ($myrow = $result->fetch_assoc()) 
         {
           $returnValue[] = $myrow;
         }
         
        return $returnValue;
    }
 
 
 
 public function getPaymentVoucherDetails( $payment_voucher_id ){

    $returnValue = array();
    $sql = "select * from payment_vouchers where id='" . $payment_voucher_id . "'";
    
    $result = $this->conn->query($sql);
    if ($result != null && (mysqli_num_rows($result) >= 1)) {
        $row = $result->fetch_array(MYSQLI_ASSOC);
        if (!empty($row)) {
            $returnValue = $row;
        }
    }
    return $returnValue;

 }
 
 public function decreaseSafeAccount( $safe_account_id , $pay ) {

    $sql = "update safe_accounts set balance = balance - $pay where id=?";
        $statement = $this->conn->prepare($sql);
        if (!$statement)
            throw new Exception($statement->error);

        $statement->bind_param("i", $safe_account_id);
        $returnValue = $statement->execute();  
        
        return $returnValue;

 }

 public function getSafeAccountDetails( $safe_account_id ){

    $returnValue = array();
    $sql = "select * from safe_accounts where id='" . $safe_account_id . "'";
    
    $result = $this->conn->query($sql);
    if ($result != null && (mysqli_num_rows($result) >= 1)) {
        $row = $result->fetch_array(MYSQLI_ASSOC);
        if (!empty($row)) {
            $returnValue = $row;
        }
    }
    return $returnValue;

 }

 public function addHistoryRecord( $balance_before , $balance_after , $history_payment_voucher_id, $history_safe_account_id , $history_descreption ){

    $sql = "insert into safe_history  set balance_before=?, balance_after =? ,payment_voucher_id =? , safe_account_id=?, descreption=? ";
    $statement = $this->conn->prepare($sql);

    if (!$statement)
        throw new Exception($statement->error);
    $statement->bind_param( "iiiis",$balance_before , $balance_after , $history_payment_voucher_id, $history_safe_account_id , $history_descreption);
     $statement->execute();
    
    $returnValue = $statement->insert_id ;
    return $returnValue;  

 }

 public function PaymentVoucherApprove ($payment_voucher_id){
		
		
		$sql = "update payment_vouchers set approve='Approved' where id=?";
        $statement = $this->conn->prepare($sql);
        if (!$statement)
            throw new Exception($statement->error);

        $statement->bind_param("i", $payment_voucher_id);
        $returnValue = $statement->execute();  
        
        return $returnValue;
		
	}
	
	public function PaymentVoucherReject ($payment_voucher_id){
		
		
		$sql = "update payment_vouchers set approve='Rejected' where id=?";
        $statement = $this->conn->prepare($sql);
        if (!$statement)
            throw new Exception($statement->error);

        $statement->bind_param("i", $payment_voucher_id);
        $returnValue = $statement->execute();  
        
        return $returnValue;
		
	}
 
}

?>
