<?php
namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use App\Main;
use App\Supplier;
use App\Waste;
use App\Packingmethod;
use App\Physicalcondition;
use App\Driver;
use App\Vehicle;
use App\User;
use App\Customer;
use App\Classification;
use App\Group;
use App\Class_;
use Carbon\Carbon;
use Auth;

class SupplierController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function showWastes()
    {

        if ( Auth::user()->is_supplier ) {
        $login_supplier_id= Auth::user()->supplier->id;
        }
        else {
            $login_supplier_id = NULL;
        }

        $supplier = Supplier::with("waste")->where('id', '=',$login_supplier_id )->get();
        //echo $supplier[0]->waste;

        $wastes= $supplier[0]->waste;
        $classes_ids = [];
        $groups_ids = [];
        $classification_ids = [];
        foreach ( $wastes as $waste){
            $classes_ids [] = $waste->class_id;
            $groups_ids [] = $waste->groups_id ;
            $classification_ids [] = $waste->classifications_id;
        }

        $classes = Class_::whereIn( "id" , $classes_ids)->get();
        $groups = Group::whereIn( "id" , $groups_ids)->get();
        $classifications = Classification::whereIn( "id" , $classification_ids)->get();

        return view('supplier.wastes' , ['wastes' => $supplier[0]->waste , 'classes'=>$classes , 'groups'=>$groups , 'classifications'=>$classifications ] );

    }

    public function showClasses()
    {

        if ( Auth::user()->is_supplier ) {
        $login_supplier_id= Auth::user()->supplier->id;
        }
        else {
            $login_supplier_id = NULL;
        }
        $supplier = Supplier::with("waste")->where('id', '=',$login_supplier_id )->get();
        
        $wastes= $supplier[0]->waste;
        $classes_ids = [];
        foreach ( $wastes as $waste){
            $classes_ids [] = $waste->class_id;
        }

        $classes = Class_::whereIn( "id" , $classes_ids)->get();

        return view('supplier.classes' , ['classes' => $classes ] );

    }
    
}
