<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/
Route::auth();
Route::get('/home', 'HomeController@index');

Route::post('/previous_waste', 'HomeController@previous_waste');
Route::get('/show_wastes', 'SupplierController@showWastes');

// tracking 
Route::get('/report/create', 'ReportController@report_create');
Route::get('/report/create/show_class/{from}/{to}', 'ReportController@get_class');
Route::get('/report/create/show_group/{class_id}/{from}/{to}', 'ReportController@get_group');
Route::get('/report/create/show_classification/{group_id}/{class_id}/{from}/{to}', 'ReportController@get_classification');
Route::get('/report/create/show_customers/{classification_id}/{group_id}/{class_id}/{from}/{to}', 'ReportController@get_customers');
Route::post('/report/create', 'ReportController@report_create_post');

// class reports 
Route::get('/class_report/create', 'ClassReportController@report_create');
Route::get('/class_report/create/ajaxclass_wastes/{from}/{to}', 'ClassReportController@get_wastes');
Route::post('/class_report/create', 'ClassReportController@class_report_create_post');

// group reports 
Route::get('/group_report/create', 'GroupReportController@report_create');
Route::get('/group_report/create/get_groups/{from}/{to}', 'GroupReportController@get_groups');
Route::post('/group_report/create', 'GroupReportController@group_report_create_post');


// chart reports 
Route::get('/chart_report/create', 'ChartReportController@report_create');
Route::get('/chart_report/create/get_classes/{from}/{to}', 'ChartReportController@get_classes');
Route::get('/chart_report/create/get_groups/{class_id}/{from}/{to}', 'ChartReportController@get_groups');
Route::get('/chart_report/create/get_classifications/{class_id}/{group_id}/{from}/{to}', 'ChartReportController@get_classifications');
Route::get('/chart_report/create/draw/{class_id}/{group_id}/{classification_id}/{from}/{to}', 'ChartReportController@draw');

Route::get('/', 'WelcomeController@index');

Route::get('/about_us', 'WelcomeController@about_us');
Route::get('/our_services', 'WelcomeController@our_services');
Route::get('/safty_policy', 'WelcomeController@safty_policy');
Route::get('/policy_data', 'WelcomeController@policy_data');
Route::get('/goal', 'WelcomeController@goal');
Route::get('/vision', 'WelcomeController@vision');
Route::get('/env_sus', 'WelcomeController@env_sus');
Route::get('/eg_waste', 'WelcomeController@eg_waste');
Route::get('/{lang}',  'WelcomeController@change_language');













