<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Cheque extends Model
{
    public $timestamps = true;
    protected $table = 'cheque';
    protected $fillable = [
       'client_id','invoice_id','serial','bank_id','date','created_at','updated_at','pay','cheque_or_deposite','payment_voucher_id','branch_id','status'
    ];


   
    public function invoice()
    {
        return $this->belongsTo('App\Invoice', 'invoice_id');
    }

    public function client()
    {
        return $this->belongsTo('App\Client', 'client_id');
    }

    public function bank()
    {
        return $this->belongsTo('App\Bank', 'bank_id');
    }

    public function payment_voucher()
    {
        return $this->belongsTo('App\Payment_Voucher', 'payment_voucher_id');
    }
    
}

