<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Daily_Safe_Account extends Model
{
    public $timestamps = true;
    protected $table = 'daily_safe_accounts';
    protected $fillable = [
       'balance','branch_id','payment_method_id','created_at','updated_at'
    ];
    public function branch()
    {
        return $this->belongsTo('App\Branch', 'branch_id');
    }
    public function payment_method()
    {
        return $this->belongsTo('App\Payment_Method', 'payment_method_id');
    }

    
}

