<?php
namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use App\Main;
use App\Sort;
use App\Branch;
use App\Store_Branch;
use App\Store_History;
use App\Payment_Method;
use App\Supplier;
use App\Waste;
use App\Packingmethod;
use App\Physicalcondition;
use App\Driver;
use App\Vehicle;
use App\User;
use App\Customer;
use Carbon\Carbon;
use Auth;
use App\Safe_Account;
use App\Client;
use App\Invoice;
use App\Invoice_Item;
use App\Invoice_Payment;
use App\Cheque;
use App\Bank;
use App\Client_Sheet;
use App\Payment_Voucher;
use App\Budget;

class BudgetController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }


public function budget_show()
{
    $budgets = Budget::get();
    return view('budget.show' , ['budgets' => $budgets]);

}


public function create_get()
{
    return view('budget.create');
}

public function create_post( Request $request)
{    
    //$branch_id = 4 ;
    $branch_id = Auth::user()->branch_id ;
    
    $budget = Budget::create ( [ 	
        'name' => $request ['name'],
        'amount' => $request['amount'],
        'temp_amount'=>0,
        'branch_id'=>$branch_id
    ] );
    session()->flash('message', 'New Budget Added Successfully');
    session()->flash('type', 'success');
    return redirect ( "/budget/create" );
}


public function edit_get($budget_id)
{
    $budget = Budget::where("id", $budget_id )->first();
    return view('budget.edit' ,  ['budget'=>$budget ]);

}

public function edit_post( Request $request)
{    
    $budget_id = $request ["budget_id"];
    $name = $request ["name"];
    $amount = $request ["amount"];

    DB::table('budgets')
    ->where('id', $budget_id)
    ->update([ 'name' =>$name, 'amount' =>$amount,
            'updated_at' => Carbon::now()
    ]);
    session()->flash('message', ' Budget Updatted Successfully');
    session()->flash('type', 'success');
    return redirect ( "/budget/edit/$budget_id" );

}



public function feed_get($budget_id)
{
    $budget = Budget::where("id", $budget_id )->first();
    return view('budget.feed' ,  ['budget'=>$budget ]);

}

public function feed_post( Request $request)
{    
    $budget_id = $request ["budget_id"];
    $temp_amount = $request ["temp_amount"];

    DB::table('budgets')
    ->where('id', $budget_id)
    ->update([ 'temp_amount' =>$temp_amount,
            'updated_at' => Carbon::now()
    ]);
    session()->flash('message', ' Budget Feeded Successfully');
    session()->flash('type', 'success');
    return redirect ( "/budget/feed/$budget_id" );

}

public function budget_details($budget_id)
{ 
    $current_month_name =  date('F Y');
    $first_day_of_month = date('Y-m-01');   
    $last_day_of_month =  date("Y-m-t", strtotime($first_day_of_month));
   
    $budget = Budget::where("id", $budget_id )->first();

    $sendats = Payment_Voucher::where("budget_id",$budget_id)
    ->whereDate('created_at','>=',$first_day_of_month)
    ->whereDate('created_at','<=',$last_day_of_month)
    ->get();

    $total_pay = Payment_Voucher::where('budget_id' ,$budget_id)->where('approve',"approved")
    ->whereDate('created_at','>=',$first_day_of_month)
    ->whereDate('created_at','<=',$last_day_of_month)
    ->sum('pay');

    return view('budget.details' ,  ['budget'=>$budget, 'sendats'=>$sendats, "total_pay"=>$total_pay , 'current_month_name'=>$current_month_name ]);
}


}
