<?php
namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use App\Main;
use App\Sort;
use App\Branch;
use App\Store_Branch;
use App\Store_History;
use App\Payment_Method;
use App\Supplier;
use App\Waste;
use App\Packingmethod;
use App\Physicalcondition;
use App\Driver;
use App\Vehicle;
use App\User;
use App\Customer;
use Carbon\Carbon;
use Auth;
use App\Safe_Account;
use App\Car_Expense;
use App\Car;

class CarController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }



    // car
public function car_show()
{
    $cars = Car::get();
    return view('car.show' , ['cars' => $cars]);
}
public function car_create_get()
{   
    return view('car.create');
}
public function car_create(Request $request) {
    
 
    $car = Car::create ( [ 		
            'num' => $request ['num'],
            'state'=>$request ['state'],
            'class'=>$request ['class'],
            'num'=>$request ['num'],
            'model'=>$request ['model'],
            'color'=>$request ['color'],
            'own_state'=>$request ['own_state'],
            'service_date'=>$request ['service_date'],
            'renewal_date'=>$request ['renewal_date'],
            'permit_date'=>$request ['permit_date'],
            'shasee_num'=>$request ['shasee_num'],
            'motor_num'=>$request ['motor_num'],
            'byan_num'=>$request ['byan_num'],
            'adad_num'=>$request ['adad_num'],
            'driver_name'=>$request ['driver_name'],
            'driver_card'=>$request ['driver_card'],
            'receive_car'=>$request ['receive_car'],
            'receive_date'=>$request ['receive_date'],
            'site'=>$request ['site'],
            'type'=>$request ['type'],

            
    ] );
    session()->flash('message', 'New car  Added Successfully');
    session()->flash('type', 'success');
    return redirect ( "/car/index" );
}

public function car_edit_get($car_id){
    $car = DB::table('cars')->where('id', '=',$car_id)->first();
    return view('car.edit',[
                            'car' => $car
                            ]);
}
public function car_edit_post(Request $request){
    $num = $request ['num'];
    $car_id = $request ['car_id']; 
    
    DB::table('cars')
        ->where('id', $car_id)
        ->update([
            'num' => $request ['num'],
            'state'=>$request ['state'],
            'class'=>$request ['class'],
            'num'=>$request ['num'],
            'model'=>$request ['model'],
            'color'=>$request ['color'],
            'own_state'=>$request ['own_state'],
            'service_date'=>$request ['service_date'],
            'renewal_date'=>$request ['renewal_date'],
            'permit_date'=>$request ['permit_date'],
            'shasee_num'=>$request ['shasee_num'],
            'motor_num'=>$request ['motor_num'],
            'byan_num'=>$request ['byan_num'],
            'adad_num'=>$request ['adad_num'],
            'driver_name'=>$request ['driver_name'],
            'driver_card'=>$request ['driver_card'],
            'receive_car'=>$request ['receive_car'],
            'receive_date'=>$request ['receive_date'],
            'site'=>$request ['site'],
            'type'=>$request ['type'],'num' => $request ['num'],
            'state'=>$request ['car_state'],
         'updated_at' => Carbon::now()]);
            
    session()->flash('message', 'car Updated successfully');
    session()->flash('type', 'success');

    return redirect ( "/car/edit/$car_id" );
}

public function car_delete($car_id){
    
    $car = Car::find($car_id);
    $car->delete();
    return redirect ( "/car/index");
}



// car expense
public function car_expense_show()
{
    $car_expenses = Car_Expense::get();
    return view('car.car_expense_show' , ['car_expenses' => $car_expenses]);
}
public function car_expense_create_get()
{   
    return view('car.car_expense_create');
}
public function car_expense_create(Request $request) {
    
    $car_expense = Car_Expense::create ( [ 		
            'name' => $request ['name']
    ] );    
    session()->flash('message', 'New car expense Added Successfully');
    session()->flash('type', 'success');
    return redirect ( "/car_expense/index" );
}

public function car_expense_edit_get($car_expense_id){
    $car_expense = DB::table('car_expenses')->where('id', '=',$car_expense_id)->first();
    return view('car.car_expense_edit',[
                            'car_expense' => $car_expense
                            ]);
}
public function car_expense_edit_post(Request $request){
    $name = $request ['name'];
    $car_expense_id = $request ['car_expense_id']; 
    
   

    DB::table('car_expenses')
        ->where('id', $car_expense_id)
        ->update(['name' => $name,
         'updated_at' => Carbon::now()]);
            
    session()->flash('message', 'car expense Updated successfully');
    session()->flash('type', 'success');

    return redirect ( "/car_expense/edit/$car_expense_id" );
}

public function car_expense_delete($car_expense_id){
    
    $car_expense = Car_Expense::find($car_expense_id);
    $car_expense->delete();
    return redirect ( "/car_expense/index");
}


 


     


}
