<?php
namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use App\Main;
use App\Sort;
use App\Branch;
use App\Store_Branch;
use App\Store_History;
use App\Payment_Method;
use App\Supplier;
use App\Waste;
use App\Packingmethod;
use App\Physicalcondition;
use App\Driver;
use App\Vehicle;
use App\User;
use App\Customer;
use Carbon\Carbon;
use Auth;
use App\Safe_Account;
use App\Daily_Safe_Account;
use App\Bank;
use App\Receipt;
use App\Payment_Voucher;
use App\Cheque;
use App\Safe_History;
use App\Transfer;

class SafeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
     
//////////////////////////////////////////////////
// payment method

public function payment_method_show()
{
    $payment_methods = Payment_Method::get();
    return view('payment_method.show' , ['payment_methods' => $payment_methods]);
}
public function payment_method_create_get()
{   
    return view('payment_method.create');
}
public function payment_method_create(Request $request) {
    
    $payment_method = Payment_Method::create ( [ 		
            'name' => $request ['name']
    ] );    
    session()->flash('message', 'New payment_method Added Successfully');
    session()->flash('type', 'success');
    return redirect ( "/payment_method/index" );
}

public function payment_method_edit_get($payment_method_id){
    $payment_method = DB::table('payment_methods')->where('id', '=',$payment_method_id)->first();
    return view('payment_method.edit',[
                            'payment_method' => $payment_method
                            ]);
}
public function payment_method_edit_post(Request $request){
    $name = $request ['name'];
    $payment_method_id = $request ['payment_method_id']; 
    
   

    DB::table('payment_methods')
        ->where('id', $payment_method_id)
        ->update(['name' => $name,
         'updated_at' => Carbon::now()]);
            
    session()->flash('message', 'payment_method Updated successfully');
    session()->flash('type', 'success');

    return redirect ( "/payment_method/edit/$payment_method_id" );
}

public function payment_method_delete($payment_method_id){
    
    $payment_method = Payment_Method::find($payment_method_id);
    $payment_method->delete();
    return redirect ( "/payment_method/index");
}

//////////////////////////////////////////////////

//banks
public function bank_show()
{
    $banks = Bank::get();
    return view('bank.show' , ['banks' => $banks]);
}
public function bank_create_get()
{   
    return view('bank.create');
}
public function bank_create(Request $request) {
    
    $bank = Bank::create ( [ 		
            'name' => $request ['name']
    ] );    
    session()->flash('message', 'New Bank Added Successfully');
    session()->flash('type', 'success');
    return redirect ( "/bank/index" );
}

public function bank_edit_get($bank_id){
    $bank = DB::table('banks')->where('id', '=',$bank_id)->first();
    return view('bank.edit',[
                            'bank' => $bank
                            ]);
}
public function bank_edit_post(Request $request){
    $name = $request ['name'];
    $bank_id = $request ['bank_id']; 
    
   

    DB::table('banks')
        ->where('id', $bank_id)
        ->update(['name' => $name,
         'updated_at' => Carbon::now()]);
            
    session()->flash('message', 'bank Updated successfully');
    session()->flash('type', 'success');

    return redirect ( "/bank/edit/$bank_id" );
}

public function bank_delete($bank_id){
    
    $bank = Bank::find($bank_id);
    $bank->delete();
    return redirect ( "/bank/index");
}




// safe account


public function safe_account_show()
{
    $branch_id = Auth::user()->branch_id ;
    $safe_accounts = Safe_Account::with('branch','payment_method')
    ->where('branch_id' ,$branch_id)
    ->get();
    return view('safe_account.show' , ['safe_accounts' => $safe_accounts]);
}
public function safe_account_create_get()
{   
    $branches = Branch::get();
    $payment_methods = Payment_Method::get();
    return view('safe_account.create', [
        'branches' => $branches,
        'payment_methods'=>$payment_methods
        ]);
}
public function safe_account_create(Request $request) {
    
    $safe_account = Safe_Account::create ( [
            'branch_id' => $request ['branch_id'],
            'payment_method_id' => $request ['payment_method_id'],
            'balance' => $request ['balance']
    ] );    
    session()->flash('message', 'New safe_account Added Successfully');
    session()->flash('type', 'success');
    return redirect ( "/safe_account/index" );
}

public function safe_account_edit_get($safe_account_id){
    $safe_account = DB::table('safe_accounts')->where('id', '=',$safe_account_id)->first();
    return view('safe_account.edit',[
                            'safe_account' => $safe_account
                            ]);
}
public function safe_account_edit_post(Request $request){
    $name = $request ['name'];
    $safe_account_id = $request ['safe_account_id']; 
    
   

    DB::table('safe_accounts')
        ->where('id', $safe_account_id)
        ->update(['name' => $name,
         'updated_at' => Carbon::now()]);
            
    session()->flash('message', 'safe_account Updated successfully');
    session()->flash('type', 'success');

    return redirect ( "/safe_account/edit/$safe_account_id" );
}

public function safe_account_delete($safe_account_id){
    
    $safe_account = Safe_Account::find($safe_account_id);
    $safe_account->delete();
    return redirect ( "/safe_account/index");
}

public function safe_account_feed_get(){

    $branch_id = Auth::user()->branch_id ;
    $banks = Bank::select('id', 'name')->get();
    $accounts = Safe_Account::with('payment_method')->where('branch_id',$branch_id)->get();
    return view('safe_account.feed',[
        'accounts' => $accounts,
        'banks'=>$banks
    ]);

}


public function safe_account_feed( Request $request)
{
    $cheque_or_deposite = $request ['cheque_or_deposite'];
    $branch_id = Auth::user()->branch_id ;
    $cheque=NULL;
    if ( $cheque_or_deposite ) {
        $cheque = Cheque::create ( [ 		
            'serial'=> $request ['serial_'] ,
            'bank_id'=> $request ['bank_id'] ,
            'date'=>$request ['date_'],
            'client_id' => NULL,
            'invoice_id'=>NULL,
            "pay"=>$request ['pay'],
            'branch_id'=>$branch_id,
            "cheque_or_deposite"=>$cheque_or_deposite=="cheque"?"cheque":"deposite"
            ]);
    }
    
    // سند القبض
    $receipt = Receipt::create ( [ 	
        'general_name'=>$request ['name'] ,
        'client_id' => NULL,
        'note1' => $request ['note1'],
        'note2' => $request ['note2'],
        'pay' => $request ['pay'],
        'cheque_id' => $cheque ? $cheque->id : NULL,
        'safe_account_id'=>$request ['safe_account_id'],
        'branch_id'=>$branch_id
    ] );

   
  
    $safe_account = Safe_Account::where( 'id', $receipt->safe_account_id)->first(); 
    Safe_History::insert ( 
        [ 	'balance_before' => $safe_account->balance,
            'balance_after' =>  $safe_account->balance + $receipt->pay ,
            'descreption' => "Safe Feed  Increase  Safe Account  $safe_account->id by $receipt->pay )",
            'user_id' => Auth::user()->id,
            'receipt_id'=>$receipt->id,
            'safe_account_id'=>$safe_account->id
        ]);

        // increase  safe account 
        DB::table('safe_accounts')
        ->where('id', $receipt->safe_account_id)
        ->update([ 'balance' => DB::raw("balance+$receipt->pay"),
                'updated_at' => Carbon::now()
        ]);
    
    //

    session()->flash('message', 'Feed Done Successfully');
    session()->flash('type', 'success');
    return redirect ( "/safe_account/feed" );

}


public function safe_account_transfer_get(){

    $branch_id = Auth::user()->branch_id ;
    $accounts = Safe_Account::with('payment_method','branch')->where('branch_id',$branch_id)->get();
    return view('safe_account.transfer',[
        'accounts' => $accounts
    ]);

}


public function safe_account_transfer_post (Request $request){

    $safe_account_id_from = $request ['safe_account_id_from'];
    $safe_account_id_to = $request ['safe_account_id_to'];
    $amount = $request ['amount'];

    $from_safe_account = Safe_Account::where( 'id', $safe_account_id_from)->first();
    if ($from_safe_account->balance < $amount ) {
        session()->flash('message', 'Transfer Money Fail , no enough money');
    session()->flash('type', 'danger');
    return redirect ( "/safe_account_transfer/create" );
    }
    DB::table('safe_accounts')
        ->where('id', $safe_account_id_from)
        ->update([ 'balance' => DB::raw("balance-$amount"),
                'updated_at' => Carbon::now()
        ]);

    DB::table('safe_accounts')
        ->where('id', $safe_account_id_to)
        ->update([ 'balance' => DB::raw("balance+$amount"),
                'updated_at' => Carbon::now()
        ]);
 
    Transfer::insert ( 
        [ 	'sender_id' => $safe_account_id_from ,
            'receiver_id' =>  $safe_account_id_to ,
            'amount' => $amount,
            'des' => NULL,
        ]);
    session()->flash('message', 'Transfer Money Done Successfully');
    session()->flash('type', 'success');
    return redirect ( "/safe_account_transfer/create" );
}


////////////////////////////////////////////
// الحسابات اليومية للخزنة 
/////////////////////////////////////////////

public function get_last_safe_accounts (){
    $branch_id = Auth::user()->branch_id ;
   
    
    $last_row_inserted = Daily_Safe_Account::latest('created_at')->where('branch_id',$branch_id)->first();
     
    $last_created_at = $last_row_inserted ? $last_row_inserted->created_at : NULL ;
    
    //$dt = new DateTime($last_created_at);
    $last_cr_at =  Carbon::parse($last_created_at)->format('Y-m-d');
    
    $date_now =  Carbon::now()->format('Y-m-d');
    
    if ($last_cr_at < $date_now  ) {
         
        return view('safe_account.daily', [
        'daily_safe_account' => [],
        'total_balance'=>0,
        'total_reciept_pay'=>0,
        'total_payment_vouchers'=>0,
        'cheques'=>[],
        'receipts'=>[],
        'payment_vouchers'=>[],
        'show_button'=>'yes'
        ]);
        
    }

    $daily_safe_account = Daily_Safe_Account::where('created_at',$last_created_at  )->where('branch_id',$branch_id)->get();
    $total_balance  = $daily_safe_account->sum('balance');

    $receipts = Receipt::whereDate( 'created_at',"=",  Carbon::now()->format('Y-m-d') )
->where('branch_id', $branch_id)
->get();
    $total_reciept_pay  = $receipts->sum('pay');

    $payment_vouchers = Payment_Voucher::where('approve',"Approved")->whereDate( 'created_at',"=",  Carbon::now()->format('Y-m-d') )
->where('branch_id', $branch_id)
->get();
    $total_payment_vouchers  = $payment_vouchers->sum('pay');
    

    $cheques = Cheque::where('date','>=',Carbon::now()->format('Y-m-d'))
->where('branch_id', $branch_id)
->get();

    $payment_vouchers = Payment_Voucher::whereDate( 'created_at',"=",  Carbon::now()->format('Y-m-d') )
->where('branch_id', $branch_id)
->where('approve', 'Approved')
->get();

    return view('safe_account.daily', [
        'daily_safe_account' => $daily_safe_account,
        'total_balance'=>$total_balance,
        'total_reciept_pay'=>$total_reciept_pay,
        'total_payment_vouchers'=>$total_payment_vouchers,
        'cheques'=>$cheques,
        'receipts'=>$receipts,
        'payment_vouchers'=>$payment_vouchers,
        'show_button'=>'no'
        ]);
}

public function start_day(){

    
    $branch_id = Auth::user()->branch_id ;
    $accounts = Safe_Account::where('branch_id', $branch_id)->get();
    $date_now =  Carbon::now()->format('Y-m-d H:i:s');
    foreach ($accounts as $key => $account) {
        $data [] = [
            'branch_id' => $account->branch_id,
            'payment_method_id' => $account->payment_method_id,
            'balance' => $account->balance,
            'created_at'=>$date_now
        ];
    }

     Daily_Safe_Account::insert($data);

     return redirect ( "/dailysafeaccount/index");
}




}
