<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use  App\Class_;
use  App\Classification;
use  App\Group;
use  App\Transporter;
use  App\Customer;
use  App\RecycleMethod;
use  App\Waste;
use App\Supplier;
use App\Main;
use Carbon\Carbon;
use Session;
use Auth;
use App\Sort;
use App\Store_Branch;
use App\Store_History;

class SellStoreReportController extends Controller
{
    
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function sell_store_report_create()
    {
        $branch_id = Auth::user()->branch_id ;

        $sell_stores = Store_Branch::where('branch_id',$branch_id)->get();
        return view('sell_store_report.create' , ['sell_stores' => $sell_stores ]);
        
    }


    public function sell_store_report_create_post(Request $request) {
    
        $sell_store_id = $request ['sell_store_id'];
        $dateFrom = $request ['from'];
        $dateTo = $request ['to'];
        
        $history = Store_History::where( [ 
                ['sell_store_id', '=',$sell_store_id]
                ])->whereDate( 'created_at',">=", $dateFrom)->whereDate('created_at',"<=", $dateTo )->get();

        
         return view('sell_store_report.show', [
            'history'=>$history , 
        ]);
        
    }

    
    public function sell_store_show() {
        $branch_id = Auth::user()->branch_id ;
        $sell_stores = Store_Branch::where('branch_id',$branch_id)->get();
        return view('sell_store_report.stores' , ['sell_stores' => $sell_stores ]);
    }
    
    public function sell_store_transfer_get(){
        $branch_id = Auth::user()->branch_id ;
        $sell_stores_my_branch = Store_Branch::where('branch_id',$branch_id)->get();
        $sell_stores = Store_Branch::get();
        return view('sell_store_report.transfer' , ['sell_stores_my_branch'=>$sell_stores_my_branch,'sell_stores' => $sell_stores ]);
    }

    public function sell_store_feed_get(){
        $branch_id = Auth::user()->branch_id ;
        $sell_stores = Store_Branch::where('branch_id',$branch_id)->get();
        return view('sell_store_report.feed' , ['sell_stores' => $sell_stores ]);
    }
    public function sell_store_transfer_post(Request $request){
        $sell_store_id_from = $request['sell_store_id_from'];
        $quantity_from = $request['quantity_from'];
        $sell_store_id_to = $request['sell_store_id_to'];
        $quantity_to = $request['quantity_to'];

        $from_sell_store = Store_Branch::where( 'id', $sell_store_id_from )->first();
        $to_sell_store = Store_Branch::where( 'id', $sell_store_id_to )->first();

        if ($quantity_from > $from_sell_store->quantity){

            session()->flash('message', "Transfer Fail, No Enough quantity in Store $sell_store_id_from");
            session()->flash('type', 'success');
            return redirect ( "/sell_store_transfer/create" );
        }

        if ($sell_store_id_from == $sell_store_id_to){

            session()->flash('message', "Transfer Fail, Choose Different Sell Stores !");
            session()->flash('type', 'success');
            return redirect ( "/sell_store_transfer/create" );
        }


        // decrease from sell_store
        DB::table('store_branch')
        ->where('id', $sell_store_id_from)
        ->update([ 'quantity' => DB::raw("quantity-$quantity_from"),
                'updated_at' => Carbon::now()
        ]);

        // increase 
        DB::table('store_branch')
        ->where('id', $sell_store_id_to)
        ->update([ 'quantity' => DB::raw("quantity+$quantity_to"),
                'updated_at' => Carbon::now()
        ]);

        // decrease
        Store_History::insert ( 
            [ 		
                'quantity_before' => $from_sell_store->quantity,
                'quantity_after' =>  $from_sell_store->quantity - $quantity_from ,
                'descreption' => "transfer from. Decrease sell store num $sell_store_id_from by $quantity_from )",
                'main_id'  => NULL,
                'user_id' => Auth::user()->id,
                'sell_store_id'=>$sell_store_id_from
            ]);

            //increase 
        Store_History::insert (
            [ 		
                'quantity_before' => $to_sell_store->quantity,
                'quantity_after' =>  $to_sell_store->quantity + $quantity_to ,
                'descreption' => "transfer in. Increase  sell store num $sell_store_id_to by $quantity_to )",
                'main_id'  => NULL,
                'user_id' => Auth::user()->id,
                'sell_store_id'=>$sell_store_id_to
            ]);


            session()->flash('message', 'Transfer Success');
            session()->flash('type', 'success');

    return redirect ( "/sell_store_transfer/create" );
    }


    public function sell_store_feed_post(Request $request){
        $sell_store_id = $request['sell_store_id'];
        $quantity = $request['quantity'];
        
        $sell_store = Store_Branch::where( 'id', $sell_store_id )->first();

        

        // increase 
        DB::table('store_branch')
        ->where('id', $sell_store_id)
        ->update([ 'quantity' => DB::raw("quantity+$quantity"),
                'updated_at' => Carbon::now()
        ]);

            //increase 
        Store_History::insert (
            [ 		
                'quantity_before' => $sell_store->quantity,
                'quantity_after' =>  $sell_store->quantity + $quantity ,
                'descreption' => "Feed in. Increase  sell store num $sell_store_id by $quantity )",
                'main_id'  => NULL,
                'user_id' => Auth::user()->id,
                'sell_store_id'=>$sell_store_id
            ]);


            session()->flash('message', 'Feed Success');
            session()->flash('type', 'success');

    return redirect ( "/sell_store_feed/create" );
    }
    
    public function edit_price_get ($sell_store_id){
        
        $sell_store = Store_Branch::where( 'id', $sell_store_id )->first();
        return view('sell_store_report.edit_price' , ['sell_store' => $sell_store]);

    } 

    public function edit_price_post (Request $request){
        $sell_store_id = $request['sell_store_id'];
        $unit_price = $request['unit_price'];
        $locked = $request['locked'];
        DB::table('store_branch')
        ->where('id', $sell_store_id)
        ->update([ 'unit_price' => $unit_price,'locked' => $locked,
                'updated_at' => Carbon::now()
        ]);
        
        session()->flash('message', 'Updated Successfully');
        session()->flash('type', 'success');

        return redirect ( "/sell_store/price_edit/$sell_store_id" ); 
    } 



}
