<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/
Route::auth();
Route::get('/', 'SafeController@get_last_safe_accounts');
Route::get('/home', 'SafeController@get_last_safe_accounts');

Route::get('/sort', 'HomeController@index');

// Store report 
Route::get('/sell_store_report/create', 'SellStoreReportController@sell_store_report_create');
Route::post('/sell_store_report/create', 'SellStoreReportController@sell_store_report_create_post');
Route::get('/sell_stores/show', 'SellStoreReportController@sell_store_show');

Route::get('/sell_store/price_edit/{sell_store_id}', 'SellStoreReportController@edit_price_get');
Route::post('/sell_store/price_edit', 'SellStoreReportController@edit_price_post');

Route::get('/sell_store_transfer/create', 'SellStoreReportController@sell_store_transfer_get');
Route::post('/sell_store_transfer/create', 'SellStoreReportController@sell_store_transfer_post');
Route::get('/sell_store_feed/create', 'SellStoreReportController@sell_store_feed_get');
Route::post('/sell_store_feed/create', 'SellStoreReportController@sell_store_feed_post');
//sort

Route::get('/main/sort/{main_id}', 'SortController@sort_get');
Route::post('/main/add_sort', 'SortController@sort_post');

/// payment method

Route::get('/payment_method/index', 'SafeController@payment_method_show');
Route::get('/payment_method/create', 'SafeController@payment_method_create_get');
Route::post('/payment_method/create', 'SafeController@payment_method_create');
Route::get('/payment_method/edit/{payment_method_id}', 'SafeController@payment_method_edit_get')->where('payment_method_id', '[0-9]+');
Route::post('/payment_method/edit', 'SafeController@payment_method_edit_post');
Route::get('/payment_method/delete/{payment_method_id}', 'SafeController@payment_method_delete')->where('payment_method_id', '[0-9]+');

/// safe account

Route::get('/safe_account/index', 'SafeController@safe_account_show');
Route::get('/safe_account/create', 'SafeController@safe_account_create_get');
Route::post('/safe_account/create', 'SafeController@safe_account_create');
Route::get('/safe_account/edit/{safe_account_id}', 'SafeController@safe_account_edit_get')->where('safe_account_id', '[0-9]+');
Route::post('/safe_account/edit', 'SafeController@safe_account_edit_post');
Route::get('/safe_account/delete/{safe_account_id}', 'SafeController@safe_account_delete')->where('safe_account_id', '[0-9]+');
Route::get('/safe_account/feed', 'SafeController@safe_account_feed_get');
Route::post('/safe_account/feed', 'SafeController@safe_account_feed');

Route::get('/safe_account_transfer/create', 'SafeController@safe_account_transfer_get');
Route::post('/safe_account_transfer/create', 'SafeController@safe_account_transfer_post');

///invoice
Route::get('/invoice/index', 'InvoiceController@invoice_show'); // create invoice
Route::get('/invoice/index/create/{array}/{array2}/{client}', 'InvoiceController@invoice_create');
Route::get('/invoice/index/get_sell_stores', 'InvoiceController@get_sell_stores');
Route::get('/invoice/index/get_safe_accounts', 'InvoiceController@get_safe_accounts');
Route::get('/invoice/show', 'InvoiceController@list_all_invoice'); // list all invoice 
Route::get('/invoice/details/{invoice_id}', 'InvoiceController@details');  
Route::get('/invoice/save/{invoice_id}', 'InvoiceController@invoice_save'); 
Route::get('/invoice/delete/{invoice_id}', 'InvoiceController@delete_invoice');  


// client
Route::get('/client/index', 'ClientController@client_show');
Route::get('/client/all_accounts', 'ClientController@client_all_accounts');
Route::post('/client/sheet', 'ClientController@create_sheet_post');
Route::get('/client/sheet', 'ClientController@create_sheet_get');

Route::get('/client/create', 'ClientController@client_create_get');
Route::post('/client/create', 'ClientController@client_create');
Route::get('/client/edit/{client_id}', 'ClientController@client_edit_get')->where('client_id', '[0-9]+');
Route::post('/client/edit', 'ClientController@client_edit_post');
Route::get('/client/delete/{client_id}', 'ClientController@client_delete')->where('client_id', '[0-9]+');

/// Bank
Route::get('/bank/index', 'SafeController@bank_show');
Route::get('/bank/create', 'SafeController@bank_create_get');
Route::post('/bank/create', 'SafeController@bank_create');
Route::get('/bank/edit/{bank_id}', 'SafeController@bank_edit_get')->where('bank_id', '[0-9]+');
Route::post('/bank/edit', 'SafeController@bank_edit_post');
Route::get('/bank/delete/{bank_id}', 'SafeController@bank_delete')->where('bank_id', '[0-9]+');

/// Car Expense
Route::get('/car_expense/index', 'CarController@car_expense_show');
Route::get('/car_expense/create', 'CarController@car_expense_create_get');
Route::post('/car_expense/create', 'CarController@car_expense_create');
Route::get('/car_expense/edit/{car_expense_id}', 'CarController@car_expense_edit_get')->where('car_expense_id', '[0-9]+');
Route::post('/car_expense/edit', 'CarController@car_expense_edit_post');
Route::get('/car_expense/delete/{car_expense_id}', 'CarController@car_expense_delete')->where('car_expense_id', '[0-9]+');

/// Car 
Route::get('/car/index', 'CarController@car_show');
Route::get('/car/create', 'CarController@car_create_get');
Route::post('/car/create', 'CarController@car_create');
Route::get('/car/edit/{car_id}', 'CarController@car_edit_get')->where('car_id', '[0-9]+');
Route::post('/car/edit', 'CarController@car_edit_post');
Route::get('/car/delete/{car_id}', 'CarController@car_delete')->where('car_id', '[0-9]+');


// cheque
Route::get('/cheque/index', 'InvoiceController@cheque_show');
Route::get('/deposites/index', 'InvoiceController@deposites_show');

Route::get('/cheque/create', 'InvoiceController@cheque_create_get');
Route::post('/cheque/create', 'InvoiceController@cheque_create');
Route::get('/cheque/edit/{cheque_id}', 'InvoiceController@cheque_edit_get')->where('cheque_id', '[0-9]+');
Route::post('/cheque/edit', 'InvoiceController@cheque_edit_post');
Route::get('/cheque/delete/{cheque_id}', 'InvoiceController@cheque_delete')->where('cheque_id', '[0-9]+');
Route::get('/cheque/details/{cheque_id}', 'InvoiceController@cheque_details')->where('cheque_id', '[0-9]+');
Route::post('/cheque/change', 'InvoiceController@cheque_change_status');

// vouchers  سند القبض
Route::get('/receipt/index', 'VoucherController@receipt_show');
Route::get('/receipt/create', 'VoucherController@receipt_create_get');
Route::post('/receipt/create', 'VoucherController@receipt_create_post');
Route::get('/receipt/print/{id}', 'VoucherController@print');

// vouchers  سند الصرف
Route::get('/payment_voucher/index', 'PaymentVoucherController@payment_voucher_show');
Route::get('/payment_voucher/general_create', 'PaymentVoucherController@general_payment_voucher_create_get');
Route::post('/payment_voucher/general_create', 'PaymentVoucherController@general_payment_voucher_create_post');
Route::get('/payment_voucher/employee_create', 'PaymentVoucherController@employee_payment_voucher_create_get');
Route::post('/payment_voucher/employee_create', 'PaymentVoucherController@employee_payment_voucher_create_post');
Route::get('/payment_voucher/budget_create', 'PaymentVoucherController@budget_payment_voucher_create_get');
Route::post('/payment_voucher/budget_create', 'PaymentVoucherController@budget_payment_voucher_create_post');
Route::get('/payment_voucher/car_create', 'PaymentVoucherController@car_payment_voucher_create_get');
Route::post('/payment_voucher/car_create', 'PaymentVoucherController@car_payment_voucher_create_post');
Route::get('/payment_voucher/not_tie_trust_create', 'PaymentVoucherController@not_tie_trust_payment_voucher_create_get');
Route::post('/payment_voucher/not_tie_trust_create', 'PaymentVoucherController@not_tie_trust_payment_voucher_create_post');
Route::get('/payment_voucher/tie_trust_create', 'PaymentVoucherController@tie_trust_payment_voucher_create_get');
Route::post('/payment_voucher/tie_trust_create', 'PaymentVoucherController@tie_trust_payment_voucher_create_post');

Route::get('/payment_voucher/print/{payment_id}', 'PaymentVoucherController@details');

// budget ميزانية 
Route::get('/budget/index', 'BudgetController@budget_show');
Route::get('/budget/create', 'BudgetController@create_get');
Route::post('/budget/create', 'BudgetController@create_post');
Route::get('/budget/edit/{budget_id}', 'BudgetController@edit_get');
Route::post('/budget/edit', 'BudgetController@edit_post');
Route::get('/budget/feed/{budget_id}', 'BudgetController@feed_get');
Route::post('/budget/feed', 'BudgetController@feed_post');
Route::get('/budget/details/{budget_id}', 'BudgetController@budget_details');


// Trust عهدة 
Route::get('/trust/index_tie', 'TrustController@trust_show_tie');
Route::get('/trust/index_not_tie', 'TrustController@trust_show_not_tie');
Route::get('/trust/create', 'TrustController@create_get');
Route::post('/trust/create', 'TrustController@create_post');
Route::get('/trust/edit/{trust_id}', 'TrustController@edit_get');
Route::post('/trust/edit', 'TrustController@edit_post');
Route::get('/trust/invoices_amount/{trust_id}', 'TrustController@invoices_amount_get');
Route::post('/trust/invoices_amount', 'TrustController@invoices_amount_post');
Route::get('/trust/tie_details/{trust_id}', 'TrustController@trust_tie_details');
Route::get('/trust/not_tie_details/{trust_id}', 'TrustController@trust_not_tie_details');
Route::get('/trust/increment_amount/{trust_id}', 'TrustController@increment_amount_get');
Route::post('/trust/increment_amount', 'TrustController@increment_amount_post');

Route::get('/trust/safe_back/{trust_id}', 'TrustController@trust_safe_back_get');
Route::post('/trust/safe_back', 'TrustController@trust_safe_back_post');
Route::get('/trust/end/{trust_id}', 'TrustController@trust_end_get');

/// Employees 
Route::get('/employee/index', 'EmployeeController@employee_show');
Route::get('/employee/create', 'EmployeeController@employee_create_get');
Route::get('/employee/analysis_create/{employee_id}', 'EmployeeController@ananlysis_create_get');
Route::get('/employee/trusts_create/{employee_id}', 'EmployeeController@trusts_create_get');
Route::post('/employee/analysis_create', 'EmployeeController@ananlysis_create_post');
Route::post('/employee/trusts_create', 'EmployeeController@trusts_create_post');
Route::post('/employee/create', 'EmployeeController@employee_create_post');
Route::get('/employee/edit/{employee_id}', 'EmployeeController@employee_edit_get')->where('employee_id', '[0-9]+');
Route::post('/employee/edit', 'EmployeeController@employee_edit_post');
Route::get('/employee/edit_analysis/{employee_id}', 'EmployeeController@edit_analysis_get')->where('employee_id', '[0-9]+');
Route::post('/employee/edit_analysis', 'EmployeeController@edit_analysis_post');
Route::get('/employee/edit_trusts/{employee_id}', 'EmployeeController@edit_trusts_get')->where('employee_id', '[0-9]+');
Route::post('/employee/edit_trusts', 'EmployeeController@edit_trusts_post');
Route::get('/employee/delete/{employee_id}', 'EmployeeController@employee_delete')->where('employee_id', '[0-9]+');
Route::get('/employee/details/{employee_id}', 'EmployeeController@details')->where('employee_id', '[0-9]+');
Route::get('/employee/image/{employee_id}', 'EmployeeController@image')->where('employee_id', '[0-9]+');
Route::post('/employee/image_create', 'EmployeeController@image_crete')->where('employee_id', '[0-9]+');



// Daily Safe Account
Route::get('/dailysafeaccount/index', 'SafeController@get_last_safe_accounts');
Route::get('/endday/index', 'SafeController@start_day');





Route::get('/backendinvoices', 'BackendController@get_invoices');
Route::get('/backendgetsellstores/{branch_id}', 'BackendController@get_sell_stores_of_branch');
Route::get('/backendgetsafeaccounts/{branch_id}', 'BackendController@get_safe_accounts_of_branch');

