<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Invoice_Payment extends Model
{
    public $timestamps = true;
    protected $table = 'invoice_payments';
    protected $fillable = [
       'payment_method_id ','invoice_id','cheque_id','created_at','updated_at','safe_account_id','pay','receipt_id'
    ];


    public function payment_method()
    {
        return $this->belongsTo('App\Payment_Method', 'payment_method_id');
    }

    public function invoice()
    {
        return $this->belongsTo('App\Invoice', 'invoice_id');
    }

    public function cheque()
    {
        return $this->belongsTo('App\Cheque', 'cheque_id');
    }

    public function safe_account()
    {
        return $this->belongsTo('App\Safe_Account', 'safe_account_id');
    }

    
}

