<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Payment_Voucher extends Model
{
    public $timestamps = true;
    protected $table = 'payment_vouchers';
    protected $fillable = [
        'client_id','pay','cheque_id','note1','note2','safe_account_id','general_name','type','approve','employee_id','budget_id','car_id','car_expense_id','trust_id','branch_id','user_id'
    ];
    

    public function safe_account()
    {
        return $this->belongsTo('App\Safe_Account', 'safe_account_id');
    }

    public function cheque()
    {
        return $this->belongsTo('App\Cheque', 'cheque_id');
    }

     
    public function client()
    {
        return $this->belongsTo('App\Client', 'client_id');
    }

    public function employee()
    {
        return $this->belongsTo('App\Employee', 'employee_id');
    }

    public function budget()
    {
        return $this->belongsTo('App\Budget', 'budget_id');
    }

    public function car()
    {
        return $this->belongsTo('App\Car', 'car_id');
    }

    public function car_expense()
    {
        return $this->belongsTo('App\Car_Expense', 'car_expense_id');
    }

    public function trust()
    {
        return $this->belongsTo('App\Trust', 'trust_id');
    }

    public function branch()
    {
        return $this->belongsTo('App\Branch', 'branch_id');
    }
}



