<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Receipt extends Model
{
    public $timestamps = true;
    protected $table = 'receipt';
    protected $fillable = [
        'client_id','pay','cheque_id','note1','note2','safe_account_id','invoice_id','branch_id','general_name'
    ];
    

    public function safe_account()
    {
        return $this->belongsTo('App\Safe_Account', 'safe_account_id');
    }

    public function cheque()
    {
        return $this->belongsTo('App\Cheque', 'cheque_id');
    }

    public function invoice()
    {
        return $this->belongsTo('App\Invoice', 'invoice_id');
    }
    public function client()
    {
        return $this->belongsTo('App\Client', 'client_id');
    }
    
    public function branch()
    {
        return $this->belongsTo('App\Branch', 'branch_id');
    }
    
    
}

