<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use  App\Class_;
use  App\Classification;
use  App\Group;
use  App\Transporter;
use  App\Customer;
use  App\RecycleMethod;
use  App\Waste;
use App\Supplier;
use App\Main;
use Carbon\Carbon;
use Session;
class ReportController extends Controller
{
    
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function report_create()
    {
        $transporters = Transporter::get();
        $customers = Customer::get();
        $suppliers = Supplier::get();
        return view('report.create' , ['suppliers' => $suppliers , 'transporters'=>$transporters, 'customers'=>$customers ]);
        
    }


     // ajax 
     public function get_class($supplier_id){
        
        Session::put('supplier_id', $supplier_id );
        $supplier = Supplier::find($supplier_id);	
        $wastes_ = $supplier->waste;

        $class_ids = []; // collect the class_ids from the wastes of supliers
        foreach ( $wastes_ as $waste_ ) {
            $class_ids[] = $waste_->class_id; 
        }
        
        $classes_ = Class_::whereIn('id', $class_ids)->groupBy('name')->get(); // get all classes where belongs to the wastes of suppliers but no dublicates 

        return \Response::json(['classes_' => $classes_ ]);	

    }

     // ajax 
     public function get_group($class_id){
        
        Session::put('class_id', $class_id );

        $supplier_id = Session::get('supplier_id');
        $supplier = Supplier::find($supplier_id);	
        $wastes_ = $supplier->waste;

        $group_ids = [];
        foreach ( $wastes_ as $waste_ ) {
            if ( $waste_->class_id == $class_id) { 
            $group_ids[] = $waste_->groups_id;  // // get all groups where belongs to the wastes of suppliers and with class_id that selected but no dublicates
            }
        }

        $groups = Group::whereIn('id', $group_ids)->groupBy('name')->get();

        return \Response::json(['groups' => $groups ]);	

    }

 // ajax 
    public function get_classification($group_id){
        

        $supplier_id = Session::get('supplier_id');
        $class_id = Session::get('class_id');

        $supplier = Supplier::find($supplier_id);	
        $wastes_ = $supplier->waste;

        $classifications_id = [];
        foreach ( $wastes_ as $waste_ ) {
            if ( $waste_->class_id == $class_id && $waste_->groups_id == $group_id  ) { 
            $classifications_id[] = $waste_->classifications_id;  // // get all groups where belongs to the wastes of suppliers and with class_id that selected but no dublicates
            }
        }

        $classifications = Classification::whereIn('id', $classifications_id)->groupBy('name')->get();

        return \Response::json(['classifications' => $classifications ]);	

    }



    public function report_create_post(Request $request) {
    
        $transporter_id = $request ['transporter_id'];
        $supplier_id = $request ['supplier_id'];
        $customer_id = $request ['customer_id'];
        $dateFrom = $request ['from'];
        $dateTo = $request ['to'];
        $logo = $request ['logo'];

        $class_id = $request ['class_id'];
        $group_id = $request ['group_id'];
        $classification_id = $request ['classification_id'];

        $class = DB::table('class')->where('id', '=',$class_id)->first();
        $group = DB::table('groups')->where('id', '=',$group_id)->first();
        $classification = DB::table('classifications')->where('id', '=',$classification_id)->first();


        $transporter = DB::table('transporters')->where('id', '=',$transporter_id)->first();

        $supplier = DB::table('suppliers')->where('id', '=',$supplier_id)->first();

        $customer = DB::table('customers')->where('id', '=',$customer_id)->first();

        $wastes = DB::table('waste')->where( [ 
            ['class_id', '=',$class_id] , 
            ['groups_id', '=',$group_id] , 
            ['classifications_id', '=',$classification_id] , 
            ])->get();

        // get all wastes ids in one D array 
        $wastes_ids = [];
        foreach ( $wastes as $waste ) {
            $wastes_ids[] = $waste->id; 
        }


        /*$mains = Main::with('waste','vehicle', 'driver', 'physicalcondition','packingmethod')->whereIn('waste_id', $wastes_ids)->
        where( [ 
            ['supplier_id', '=',$supplier_id] , 
            ['customer_id', '=',$customer_id] ,
            ])->get();
            */

            $mains = Main::with('waste','vehicle', 'driver', 'physicalcondition','packingmethod')->whereIn('waste_id', $wastes_ids)->
                where( [ 
                    ['supplier_id', '=',$supplier_id] , 
                    ['customer_id', '=',$customer_id] ,
                    ])->whereDate( 'created_at',">=", $dateFrom)->whereDate('created_at',"<=", $dateTo )->get();

        
         return view('report.show', [
            'supplier'=>$supplier , 
            'transporter'=>$transporter ,
            'customer'=>$customer,
            'mains'=>$mains,
            'class'=>$class,
            'group'=>$group,
            'classification'=>$classification,
            'dateFrom'=>$dateFrom,
            'dateTo'=>$dateTo,
            'logo'=>$logo
        ]);
        
    }

    




}
