<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Activity;

class Supplier extends Model
{
    public $timestamps = true;
    protected $table = 'suppliers';
    protected $fillable = [
       'name','address','phone','fax','email','environmental_response','resp_position','resp_phone','resp_phone','resp_email','commertial_registration_no','tax_card_no','operating_licence_no','industrial_registration_no','created_at','updated_at','industrial_city_id'
    ];

    public function city()
    {
        return $this->belongsTo('App\City', 'industrial_city_id');
    }

    public function activitys()
    {
        return $this->belongsToMany(Activity::class,'activity_supplier');
    }

    public function waste()
    {
        return $this->belongsToMany(Waste::class,'supplier_waste');
    }


}

