<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use App\Message;
use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Str;

class MessageController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }


    public function message_show()
    {
        $messages = Message::get();
        return view('message.show' , ['messages' => $messages]);
    }
    public function message_create_get()
    {
        return view('message.create');
    }
    public function message_create(Request $request) {
        
        $message = Message::create ( [ 		
                'body' => $request ['body'],
                'title' => $request ['title'],
                'status' => $request ['status']
        ] );    
        session()->flash('message', 'New message Added Successfully');
        session()->flash('type', 'success');
        return redirect ( "/message/index" );
    }
    
    public function message_edit_get($message_id){
        $message = DB::table('messages')->where('id', '=',$message_id)->first();
        return view('message.edit',[
                                'message' => $message
                                ]);
    }
    public function message_edit_post(Request $request){
        $message_id = $request ['message_id'];
         $body = $request ['body']; 
         $title = $request ['title']; 
         $status = $request ['status'];
        DB::table('messages')
            ->where('id', $message_id)
            ->update([  'body' => $body,
                        'title' => $title,
                        'status' => $status,
                        'updated_at' => Carbon::now()]);
                
        session()->flash('message', 'message Updated successfully');
        session()->flash('type', 'success');
    
        return redirect ( "/message/edit/$message_id" );
    }

    public function message_delete($message_id){
        
        $message = Message::find($message_id);
        $message->delete();
        return redirect ( "/message/index");
    }
     

}
