<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Store_Branch extends Model
{
    public $timestamps = true;
    protected $table = 'store_branch';
    protected $fillable = [
       'quantity','created_at','updated_at','store_id','branch_id'
    ];

    public function store()
    {
        return $this->belongsTo('App\Store', 'store_id');
    }

    public function branch()
    {
        return $this->belongsTo('App\Branch', 'branch_id');
    }
    
}

