<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>EgWaste </title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->

  <link rel='stylesheet' href='{{asset("bootstrap/css/bootstrap.min.css")}}'>

  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">

  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->

  <link rel='stylesheet' href='{{asset("dist/css/AdminLTE.min.css")}}'>

  <!-- iCheck -->
  <link rel='stylesheet' href='{{asset("plugins/iCheck/square/blue.css")}}'>
  <link rel="icon" type="image/x-icon" href="{{asset('dist/img/logo.png')}}">


  <style>
    * {
  padding: 0;
  margin: 0;
  outline: none;
  -webkit-box-sizing: border-box;
  -moz-box-sizing: border-box;
  box-sizing: border-box;
}

body {
  background: #1f1542;
}

#work {
  width: 300px;
  margin: 0 auto;
  position: relative;
  top: -20px;
  -webkit-animation-name: routate;
  -webkit-animation-duration: 4s;
  -webkit-animation-iteration-count: infinite;
  animation-name: routate;
  animation-duration: 5s;
  animation-iteration-count: infinite;
}

@-webkit-keyframes routate {
  0% {
    -webkit-transform: rotate(7deg);
    -ms-transform: rotate(7deg);
    transform: rotate(7deg);
  }
  50% {
    -webkit-transform: rotate(-7deg);
    -ms-transform: rotate(-7deg);
    transform: rotate(-7deg);
  }
  100% {
    -webkit-transform: rotate(7deg);
    -ms-transform: rotate(7deg);
    transform: rotate(7deg);
  }
}

@keyframes routate {
  0% {
    -webkit-transform: rotate(7deg);
    -ms-transform: rotate(7deg);
    transform: rotate(7deg);
  }
  50% {
    -webkit-transform: rotate(-7deg);
    -ms-transform: rotate(-7deg);
    transform: rotate(-7deg);
  }
  100% {
    -webkit-transform: rotate(7deg);
    -ms-transform: rotate(7deg);
    transform: rotate(7deg);
  }
}

#work #wire {
  margin: 0 auto;
  height: 130px;
  width: 10px;
  background: #261647;
  border: 5px #0c032e solid;
}

#work #c1 {
  position: absolute;
  z-index: 5;
  bottom: 0;
  height: 300px;
}

#work .light {
  width: 100%;
  height: 100%;
  padding: 30px;
  margin: 0 auto;
  background: rgba(255, 155, 0, 0.08);
  -webkit-border-radius: 100%;
  -moz-border-radius: 100%;
  border-radius: 100%;
  -webkit-animation-name: flash;
  -webkit-animation-duration: 4s;
  -webkit-animation-iteration-count: infinite;
  animation-name: flash;
  animation-duration: 1s;
  animation-iteration-count: infinite;
}

@-webkit-keyframes flash {
  0% {
    background: rgba(255, 155, 0, 0.08);
  }
  50% {
    background: rgba(255, 155, 0, 0.04);
  }
  100% {
    background: rgba(255, 155, 0, 0.08);
  }
}

@keyframes flash {
  0% {
    background: rgba(255, 155, 0, 0.08);
  }
  50% {
    background: rgba(255, 155, 0, 0.04);
  }
  100% {
    background: rgba(255, 155, 0, 0.08);
  }
}

#fanos {
  height: 380px;
  padding: 10px;
  margin: 0 auto;
  position: relative;
  top: -20px;
}

#small-circle {
  margin: 0 auto;
  width: 30px;
  height: 30px;
  -webkit-border-radius: 100%;
  -moz-border-radius: 100%;
  border-radius: 100%;
  background: #261647;
  border: 5px #0c032e solid;
  position: relative;
  z-index: 5;
}

#half-circle {
  width: 120px;
  height: 120px;
  position: absolute;
  top: 25px;
  left: 50%;
  -webkit-transform: translateX(-50%);
  -ms-transform: translateX(-50%);
  transform: translateX(-50%);
  z-index: 1;
  -webkit-border-radius: 100%;
  -moz-border-radius: 100%;
  border-radius: 100%;
  background: #40315a;
  border: 5px #0c032e solid;
}

#bottom-quppa {
  margin: 0 auto;
  position: relative;
  top: 50px;
  z-index: 3;
}

#line {
  margin: 0 auto;
  width: 200px;
  height: 30px;
  padding-top: 3px;
  background: #261647;
  border: 5px #0c032e solid;
  overflow: hidden;
  text-align: center;
}

#line .ball {
  width: 15px;
  height: 15px;
  margin: auto 5px;
  display: inline-block;
  -webkit-border-radius: 100%;
  -moz-border-radius: 100%;
  border-radius: 100%;
  background: #40315a;
  border: 5px #0c032e solid;
}

#top-triangle {
  margin: 0 auto;
  width: 210px;
  height: 0;
  border-left: 25px transparent solid;
  border-right: 25px transparent solid;
  border-bottom: 30px #0c032e solid;
  position: relative;
  top: -5px;
}

#top-triangle:after {
  content: '';
  display: block;
  position: absolute;
  z-index: 3;
  left: 50%;
  -webkit-transform: translateX(-50%);
  -ms-transform: translateX(-50%);
  transform: translateX(-50%);
  top: 5px;
  width: 155px;
  height: 0;
  border-left: 15px transparent solid;
  border-right: 15px transparent solid;
  border-bottom: 20px #40315a solid;
}

#box {
  width: 170px;
  margin: 0 auto;
  height: 180px;
  background: rgba(255, 255, 255, 0.1);
  position: relative;
  top: -10px;
  z-index: 1;
  border: 5px #0c032e solid;
}

#box #candel {
  height: 60px;
  width: 30px;
  background: #ffffff;
  border: 5px #0c032e solid;
  border-bottom: 0;
  position: absolute;
  z-index: 1;
  left: 65px;
  bottom: 0;
}

#box #candel:after {
  content: '';
  display: block;
  margin: 0 auto;
  position: relative;
  top: -20px;
  width: 10px;
  height: 15px;
  -webkit-border-radius: 100%;
  -moz-border-radius: 100%;
  border-radius: 100%;
  background: #ff9b00;
  border: 5px #0c032e solid;
}

#box #col {
  margin: 0 auto;
  width: 90px;
  height: 170px;
  border-left: 5px #0c032e solid;
  border-right: 5px #0c032e solid;
  position: relative;
  z-index: 2;
  background: rgba(255, 255, 255, 0.1);
}

#final {
  position: relative;
  z-index: 4;
  top: -15px;
}

#last-triangle {
  margin: 0 auto;
  width: 245px;
  height: 0;
  border-left: 25px transparent solid;
  border-right: 25px transparent solid;
  border-bottom: 25px #0c032e solid;
  position: relative;
  top: -5px;
}

#last-triangle:after {
  content: '';
  display: block;
  position: absolute;
  z-index: 3;
  left: 50%;
  -webkit-transform: translateX(-50%);
  -ms-transform: translateX(-50%);
  transform: translateX(-50%);
  top: 5px;
  width: 190px;
  height: 0;
  border-left: 15px transparent solid;
  border-right: 15px transparent solid;
  border-bottom: 15px #40315a solid;
}
















@import
  url(https://fonts.googleapis.com/css?family=VT323);

:root {
  --star-color-A: white;
  --star-color-B: transparent;
}

html {
  min-height: 100%;
}

body {
  font-family: "VT323";
  font-size: 2rem;
  background: linear-gradient(
    0deg,
    rgb(25,25,112),
    rgb(33,20,0) 30%);
    rgb(0, 0, 0) 80%;
}

.lable {
  color: white;
  display: inline-block;
  text-align: center;
}

.slider {
  display: block;
}

.circle {
  position: absolute;
  /*width: 10px;
  height: 10px;
  left: 100px;
  top: 20px; */
  background-color: var(--star-color-A);
  border-radius: 50%;
  animation-duration: 4s;
  animation-iteration-count: infinite;
  /*animation-direction: alternate;*/
}

.blink_1 {
  animation-name: blink10;
}

.blink_2 {
  animation-name: blink20;
}

.blink_3 {
  animation-name: blink30;
}

.blink_4 {
  animation-name: blink40;
}

.blink_5 {
  animation-name: blink50;
}

@keyframes blink10 {
  0%, 100% {
    background-color: var(--star-color-A);
  }
  20% {
    background-color: var(--star-color-B);
  }
}

@keyframes blink20 {
  0%, 100% {
    background-color: var(--star-color-B);
  }
  40% {
    background-color: var(--star-color-A);
  }
}

@keyframes blink50 {
  0%, 100% {
    background-color: var(--star-color-A);
  }
  50% {
    background-color: var(--star-color-B);
  }
}

@keyframes blink30 {
  0%, 100% {
    background-color: var(--star-color-A);
  }
  60% {
    background-color: var(--star-color-B);
  }
}

@keyframes blink40 {
  0%, 100% {
    background-color: var(--star-color-B);
  }
  80% {
    background-color: var(--star-color-A);
  }
}



















html, body, div, span, applet, object, iframe,
h1, h2, h3, h4, h5, h6, p, blockquote, pre,
a, abbr, acronym, address, big, cite, code,
del, dfn, em, img, ins, kbd, q, s, samp,
small, strike, strong, sub, sup, tt, var,
b, u, i, center,
dl, dt, dd, ol, ul, li,
fieldset, form, label, legend,
table, caption, tbody, tfoot, thead, tr, th, td,
article, aside, canvas, details, embed, 
figure, figcaption, footer, header, hgroup, 
menu, nav, output, ruby, section, summary,
time, mark, audio, video {
	margin: 0;
	padding: 0;
	border: 0;
	font-size: 100%;
	font: inherit;
	vertical-align: baseline;
}
article, aside, details, figcaption, figure, 
footer, header, hgroup, menu, nav, section {
	display: block;
}
body {
	line-height: 1;
}
ol, ul {
	list-style: none;
}
blockquote, q {
	quotes: none;
}
blockquote:before, blockquote:after,
q:before, q:after {
	content: '';
	content: none;
}
table {
	border-collapse: collapse;
	border-spacing: 0;
}

$blockCenter:0 auto;
$nightColor:#080942;
$moonColor:#8a7f8d;
$lightNightColor:#72538f;


html, body{
	padding: 0;
	margin:0;
	background-color: #2C3E50;
}
.innerImg{
	overflow: hidden;
}

.buttons{
	text-align: center;
	position: fixed;
	top:30px;
	right: -200px;
	width: 100px;
	button{
		width: 100px;
		margin-bottom: 10px;
		font-size: 15px;
		float: right;
		display: block;
		height:30px;
		color:#fff;
		border-style: none;
		outline: none;
		cursor: pointer;
		box-shadow: 2px 2px 5px #000;
	}
	#play{
		background-color:#00B16A;
	}#restart{
		background-color: #D35400;
	}#pause{
		background-color: #D91E18;
	}

}
svg#svgObj {
    overflow: overlay;
    width: 500px;
    margin: 10px auto;
    display: block;

}
svg#svgObj > #cardSVG{
	box-shadow: 10px 10px 10px #ccc;

}




  </style>
</head>

<!-- 
  style="height:1px;background: linear-gradient(145deg,rgb(165 227 190) , rgba(51,184,53,1));"
  <body class="hold-transition skin-blue layout-boxed sidebar-mini"  style="height:1px; background: linear-gradient(145deg,rgb(165 227 190) , rgba(51,184,53,1));">
-->
<body >


   

  <div class="sky"></div>
<div id="work" style="margin-top:-20px">
  <div id="wire"></div>
  <div id="fanos">
    <div id="small-circle"></div>
    <div id="half-circle"></div>
    <div id="bottom-quppa">
      <div id="line">
        <span class="ball"></span>
        <span class="ball"></span>
        <span class="ball"></span>
        <span class="ball"></span>
        <span class="ball"></span>
        <span class="ball"></span>
        <span class="ball"></span>
      </div>
      <div id="top-triangle"></div>
      <div id="box">
        <div id="candel"></div>
        <div id="col"></div>
      </div>
      <div id="final">
        <div id="line"></div>
        <div id="last-triangle"></div>
      </div>
    </div>
  </div>
  <div class="light" id="c1">
    <div class="light">
      <div class="light">
        <div class="light">
        </div>
      </div>
    </div>
  </div>
</div>

<div class="login-box" style="margin-top: -10px;">
  
  <!-- /.login-logo -->
  <div class="login-box-body" style="border-radius: 20px; padding:35px;background-color: #6c5454;">

    <form class="form-horizontal" role="form" method="POST" action="{{ url('/login') }}">
                        {{ csrf_field() }}
      <div class="form-group has-feedback" style="background: #1f1542;">
        <input id="email" type="text" name="email" class="form-control" placeholder="Email">
        <span class="glyphicon glyphicon-envelope form-control-feedback"></span>
      </div>
      <div class="form-group has-feedback">
        <input type="password" id="password" name="password" class="form-control" placeholder="Password">
        <span class="glyphicon glyphicon-lock form-control-feedback"></span>
      </div>
      <div class="row">

      <div class="col-xs-14">
          <button type="submit" class="btn btn-success btn-block " style="background-color: #533c51;
    border-color: #40315a;">Sign in  </button>
        </div>
      
        
        <!-- /.col -->
       
        <!-- /.col -->
      </div>
    </form>

  </div>
  <!-- /.login-box-body -->
</div>
<!-- /.login-box -->

<!-- jQuery 2.2.3 -->
<script type='text/javascript' src='{{asset("plugins/jQuery/jquery-2.2.3.min.js")}}'></script>


<!-- Bootstrap 3.3.6 -->
<script type='text/javascript' src='{{asset("bootstrap/js/bootstrap.min.js")}}'></script>

<!-- iCheck -->
<script type='text/javascript' src='{{asset("plugins/iCheck/icheck.min.js")}}'></script>

<script>
  $(function () {
    $('input').iCheck({
      checkboxClass: 'icheckbox_square-blue',
      radioClass: 'iradio_square-blue',
      increaseArea: '20%' // optional
    });
  });
  
  
  
  let sky = document.querySelector('.sky');

function createDiv(size) {
  
  let circle = document.createElement('div');
  circle.classList.add('circle');
  
  let randRange5 = Math.floor(Math.random() * 5) + 1;
  circle.classList.add(`blink_${randRange5}`);
  
  let widthAndHeight = random(size, 'px');
  circle.style.height = circle.style.width = widthAndHeight;
  
  circle.style.left = random(window.innerWidth, 'px');
  circle.style.top = random(window.innerHeight, 'px');
  // circle.style.backgroundColor = randomColor();
  
  sky.appendChild(circle);
}





function paintStars(stars, size) {
  while (sky.firstChild) {
    sky.removeChild(sky.firstChild);
  }
  for (let i = 0; i < stars; i++) {
    createDiv(size);
  }
}


function random(range, unit) {
  let randNum = Math.floor(Math.random() * range) + 1;
  return `${randNum}${unit}`;
}

paintStars(100, 10);


</script>
</body>
</html>