<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use App\Main;
use App\Supplier;
use App\Waste;
use App\Packingmethod;
use App\Physicalcondition;
use App\Driver;
use App\Vehicle;
use App\User;
use App\Customer;
use Carbon\Carbon;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // group chatr 
        $charts = DB::table('mains')
        ->select( 'waste.unit' ,'groups.name',DB::raw('SUM(mains.quantity) AS total_quantity'))
        ->join('waste',  'waste.id', '=', 'mains.waste_id')
        ->join('groups',  'groups.id', '=', 'waste.groups_id')->groupBy('groups.name')->get();
        //     print_r ($charts );    
        $wastes = Main::with('supplier' , 'waste' , 'packingmethod' , 'physicalcondition' , 'driver' , 'vehicle' , 'user', 'price')->get();
        return view('home' , ['wastes' => $wastes , 'charts'=>$charts] );
       
    }

    public function not_approved()
    {
                 
        $wastes = Main::with('supplier' , 'waste' , 'packingmethod' , 'physicalcondition' , 'driver' , 'vehicle' , 'user', 'price')->where("approve",NULL)->get();
        return view('home' , ['wastes' => $wastes , 'charts'=>NULL] );
       
    }

    public function not_sent_to_customer()
    {
                 
        $wastes = Main::with('supplier' , 'waste' , 'packingmethod' , 'physicalcondition' , 'driver' , 'vehicle' , 'user', 'price')->
        where([
            ['approve', '=', 'approved'],
            ['customer_id', "=", NULL]
            ])->get();
        return view('home' , ['wastes' => $wastes , 'charts'=>NULL] );
       
    }


    public function main_edit_get($main_id){
        $main = Main::with('supplier' , 'waste' , 'packingmethod' , 'physicalcondition' , 'driver' , 'vehicle' , 'user')->where('id',$main_id)->first();
        $suppliers = Supplier::get();
        $packingmethods = Packingmethod::get();
        $drivers = Driver::get();
        $physicalconditions = Physicalcondition::get();
        $vehicles = Vehicle::get();
        $users = DB::table('users')->where('is_supplier', '!=',NULL)->get();

        // many to many relation ship
        $supplier = Supplier::find($main->supplier->id);  // here is the supplier id from the row first
        $wastes = $supplier->waste; // relation many to many

        return view('mainedit',[
                'main' => $main, 
                'suppliers' => $suppliers,
                'packingmethods' => $packingmethods,
                'drivers' => $drivers,
                'physicalconditions' => $physicalconditions,
                'vehicles' => $vehicles,
                'users' => $users,
                'wastes'=>$wastes  // wastes of the specific suppliers from relation many to many
        ]);
        
    }


    public function main_edit_post(Request $request){
        $main_id = $request ['main_id'];
        $quantity = $request ['quantity']; 
        $supplier_id = $request ['supplier_id']; 
        $waste_id = $request ['waste_id']; 
        $packingmethod_id = $request ['packingmethod_id']; 
        $physicalcondition_id = $request ['physicalcondition_id']; 
        $driver_id = $request ['driver_id'];
        $vehicle_id = $request ['vehicle_id'];
        $user_id = $request ['user_id'];
       DB::table('mains')
           ->where('id', $main_id)
           ->update([
                     'quantity' => $quantity,
                     'supplier_id' => $supplier_id,
                     'waste_id' => $waste_id,
                     'packingmethod_id' => $packingmethod_id,
                     'physicalcondition_id' => $physicalcondition_id,
                     'driver_id' => $driver_id,
                     'vehicle_id' => $vehicle_id,
                     'user_id' => $user_id 
                    ]);
               
       session()->flash('message', 'Main Fields Updated successfully');
       session()->flash('type', 'success');
   
       return redirect ( "/main/edit/$main_id" );
   }






    public function change_customer_edit_get($main_id){
        $main = Main::where('id',$main_id)->first();
        $customers = Customer::get();
      

        return view('changecustomer',[
                'main' => $main, 
                'customers'=>$customers,
         ]);
        
    }

    public function change_customer_edit_post( Request $request){
      
        $main_id = $request ['main_id'];
        $customer_id = $request ['customer_id'];
        DB::table('mains')
            ->where('id', $main_id)
            ->update(['customer_id' => $customer_id]);
		        
        session()->flash('message', 'Customer Changed successfully');
        session()->flash('type', 'success');

        return redirect ("/home");


        
    }



    public function main_approve($waste_id){
        
        DB::table('mains')
          ->where('id', $waste_id)
          ->update(['approve' => "approved", 'updated_at' => Carbon::now()]);
              
        return redirect ("/home");
        
    }

    // ajax 
    public function main_get_waste_supplier($supplier_id){
        
        $supplier = Supplier::find($supplier_id);	
        $wastes_ = $supplier->waste;

        return \Response::json ( [ 
				'wastes_' => $wastes_ 
		] ); 


    }

     public function notfound()
    {
        return view('404' );
    }
    
    
}
