<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use  App\Permit;
use  App\Vehicle;
use  App\Driver;
use Carbon\Carbon;
use App\Main;
class DriverReportController extends Controller
{
    
    public function __construct()
    {
        $this->middleware('auth');
    }

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Driver Report
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

public function driver_report_create_get()
{
    return view('driverreport.create');
}

public function get_drivers( $from , $to){
        
        $mains = Main::with("driver")
                                    ->whereDate('created_at','>=',$from)
                                    ->whereDate('created_at','<=',$to)
                                    //->where('customer_id' , '!=' , NULL)                            
                                    ->groupBy('driver_id')
                                    ->get();
         

        /*echo $mains;
        $drivers_ids = [];
        foreach ( $mains as $main ) {
            $drivers_ids[] = $main->driver->id;
        }

        $drivers = Driver::whereIn('id', $drivers_ids)->groupBy('name')->get();
        echo " ------------------------";
        echo $drivers;
        return ;
        */
        return \Response::json(['mains' => $mains, ]);

    }


public function driver_report_create_post(Request $request) {


     
        
        $dateFrom = $request ['from'];
        $dateTo = $request ['to'];
        $selected_drivers = $request ['selected_drivers']; 
       
        //echo $selected_drivers; 

        $mains = Main::with("waste", "supplier", "driver")
        ->whereIn('driver_id', $selected_drivers)
        ->whereDate('created_at','>=',$dateFrom)
        ->whereDate('created_at','<=',$dateTo)
        ->orderBy('created_at', 'asc')
        ->get();
         
        
         //return ;

        return view('driverreport.show', [
            'mains'=>$mains,
            'dateFrom'=>$dateFrom,
            'dateTo'=>$dateTo
        ]);
        
    
 }



////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Vehicles Report
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

public function vehicle_report_create_get()
{
    return view('vehiclereport.create');
}

public function get_vehicles( $from , $to){
        
        $mains = Main::with("vehicle")
                                    ->whereDate('created_at','>=',$from)
                                    ->whereDate('created_at','<=',$to)
                                    //->where('customer_id' , '!=' , NULL)                            
                                    ->groupBy('vehicle_id')
                                    ->get();
         
        return \Response::json(['mains' => $mains, ]);

    }


public function vehicle_report_create_post(Request $request) {


     
        
        $dateFrom = $request ['from'];
        $dateTo = $request ['to'];
        $selected_vehicles = $request ['selected_vehicles']; 
       

        $mains = Main::with("waste", "supplier", "vehicle")
        ->whereIn('vehicle_id', $selected_vehicles)
        ->whereDate('created_at','>=',$dateFrom)
        ->whereDate('created_at','<=',$dateTo)
        ->orderBy('created_at', 'asc')
        ->get();
         
      

        return view('vehiclereport.show', [
            'mains'=>$mains,
            'dateFrom'=>$dateFrom,
            'dateTo'=>$dateTo
        ]);
        
    
 }




}
