<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use App\Main;
use App\Supplier;
use App\Waste;
use App\Packingmethod;
use App\Physicalcondition;
use App\Driver;
use App\Vehicle;
use App\User;
use App\Branch;
use App\Customer;
use Carbon\Carbon;
use Auth; 
use DateTime;
use App\Actions;
use App\Store_History;
class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
         
                $wastes = Main::with('supplier' , 'waste' , 'packingmethod' , 'physicalcondition' , 'driver' , 'vehicle' , 'user', 'admin_approve', 'admin_sender', 'branch')->where( 'date',"=",  Carbon::now()->format('Y-m-d') )->get();
                
                
         // sleep(5);
         
         if(Auth::user()->id == 85 ) {
         
             ///////////////// action /////////////////
        
       $action = "Admin login a.nasser " ;
       Actions::create ( [ 		
        'user' => Auth::user()->name ,
        'action' => $action,
        'comment' => "Admin login a.nasser "
            ] );
        /////////////////////////////////
         }
         
        return view('home' , ['wastes' => $wastes ] );
       
    }

public function actions()
    {
         
      $actions = Actions::get();
      return view('actions' , ['actions' => $actions ] );
       
    }
    
public function group_charts()
    {
        
        // comment all and 
        
        /*
        $charts = DB::table('mains')
        ->select( 'waste.unit' ,'groups.name',DB::raw('SUM(mains.quantity) AS total_quantity'))
        ->join('waste',  'waste.id', '=', 'mains.waste_id')
        ->join('groups',  'groups.id', '=', 'waste.groups_id')->groupBy('groups.name')->get();
           
          return view('groups' , [ 'charts'=>$charts] );
       */
       
       
          ///////////////// action /////////////////
        
       $action = "Group Chart " ;
       Actions::create ( [ 		
        'user' => Auth::user()->name ,
        'action' => $action,
        'comment' => "Group Chart "
            ] );
        /////////////////////////////////
        
       
        return view('groups' , ['charts'=>[] ] );
       
    }
    public function not_approved( Request $request )
    {
                 
        $from =  $request ['from'];
        $to =  $request ['to'];
        $wastes = Main::with('supplier' , 'waste' , 'packingmethod' , 'physicalcondition' , 'driver' , 'vehicle' , 'user')->where("approve",NULL)->where('date','>=',$from)
                        ->where('date','<=',$to)
                        ->get();
                        
        
          ///////////////// action /////////////////
        
       $action = "Not Approved Report : " ;
       Actions::create ( [ 		
        'user' => Auth::user()->name ,
        'action' => $action,
        'comment' => "Not Approved Report from $from to $to "
            ] );
        /////////////////////////////////
        
        return view('home' , ['wastes' => $wastes , 'charts'=>NULL] );
        
    }

    public function not_sent_to_customer( Request $request )
    {
                 
        $from =  $request ['from'];
        $to =  $request ['to'];
        $wastes = Main::with('supplier' , 'waste' , 'packingmethod' , 'physicalcondition' , 'driver' , 'vehicle' , 'user')->
        where([
            ['approve', '=', 'approved'],
            ['customer_id', "=", NULL]
            ])->where('date','>=',$from)
                        ->where('date','<=',$to)
                        ->get();
       
         ///////////////// action /////////////////
        
       $action = "Not Sent to customer  Report : " ;
       Actions::create ( [ 		
        'user' => Auth::user()->name ,
        'action' => $action,
        'comment' => "Not Sent to customer  Report from $from to $to "
            ] );
        /////////////////////////////////
        
        return view('home' , ['wastes' => $wastes , 'charts'=>NULL] );
       
    }
    
     public function sent_to_customer (Request $request)
    {
        
        $from =  $request ['from'];
        $to =  $request ['to'];
        $wastes = Main::with('supplier' , 'waste' , 'packingmethod' , 'physicalcondition' , 'driver' , 'vehicle' , 'user')->
        where([
            ['approve', '=', 'approved'],
            ['customer_id', "!=", NULL]
            ])->where('date','>=',$from)
                        ->where('date','<=',$to)
                        ->get();
                        
        //////////////// action /////////////////
        
       $action = "Sent to customer  Report : " ;
       Actions::create ( [ 		
        'user' => Auth::user()->name ,
        'action' => $action,
        'comment' => "Sent to customer  Report from $from to $to "
            ] );
        /////////////////////////////////
        
        return view('home' , ['wastes' => $wastes , 'charts'=>NULL] );
       
    }
    


    public function main_edit_get($main_id){
        $main = Main::with( 'packingmethod' , 'physicalcondition' , 'driver' , 'vehicle' , 'user')->where('id',$main_id)->first();
        $packingmethods = Packingmethod::get();
        $drivers = Driver::get();
        $physicalconditions = Physicalcondition::get();
        $vehicles = Vehicle::get();
        $users = DB::table('users')->where('is_supervisor', '!=',NULL)->get();

        $supplier = Supplier::find($main->supplier->id);  // here is the supplier id from the row first
        $wastes = $supplier->waste; // relation many to many
        // to check if there is waste fakena rabta bta3to from supplier , 
        // no edit on the carta , hide save button 
        $expired_supplier_waste = "yes";

        foreach ($wastes as $waste) {
            // check if waste still exist in supplier list 
         if ( $waste->id == $main->waste_id ){
            $expired_supplier_waste="no";
            break;
         }
        }

        ////////////////

        //sleep(5);
        return view('mainedit',[
                'main' => $main, 
                'packingmethods' => $packingmethods,
                'drivers' => $drivers,
                'physicalconditions' => $physicalconditions,
                'vehicles' => $vehicles,
                'users' => $users,
                "expired_supplier_waste"=>$expired_supplier_waste,
        ]);
        
    }
    
    
    public function main_advancededit_get($main_id){
        $main = Main::with('supplier' , 'waste' , 'branch')->where('id',$main_id)->first();
        $suppliers = Supplier::get();
        // many to many relation ship
        $supplier = Supplier::find($main->supplier->id);  // here is the supplier id from the row first
        $wastes = $supplier->waste; // relation many to many
        $branches = Branch::get();
        // to check if there is waste fakena rabta bta3to from supplier , 
        // no edit on the carta , hide save button 
        $expired_supplier_waste = "yes";

        foreach ($wastes as $waste) {
            // check if waste still exist in supplier list 
         if ( $waste->id == $main->waste_id ){
            $expired_supplier_waste="no";
            break;
         }
        }
        return view('advancedmainedit',[
                'main' => $main, 
                'suppliers' => $suppliers,
                'branches'=>$branches,
                "expired_supplier_waste"=>$expired_supplier_waste,
                'wastes'=>$wastes  // wastes of the specific suppliers from relation many to many
        ]);
        
    }



    public function main_edit_post(Request $request){
        $main_id = $request ['main_id'];
        $packingmethod_id = $request ['packingmethod_id']; 
        $physicalcondition_id = $request ['physicalcondition_id']; 
        $driver_id = $request ['driver_id'];
        $vehicle_id = $request ['vehicle_id'];
        $user_id = $request ['user_id'];
        $comment = $request ['comment'];
        //added 
        $created_at = $request ['created_at'];
        $updated_at = $request ['updated_at'];
        $tax = $request ['tax'];
        ////
        
        $old_main = Main::where('id',$main_id)->first();
        
        $current_date_time = new \DateTime($created_at);
        $date__ = $current_date_time->format("Y-m-d");
        
       DB::table('mains')
           ->where('id', $main_id)
           ->update([
                     'packingmethod_id' => $packingmethod_id,
                     'physicalcondition_id' => $physicalcondition_id,
                     'driver_id' => $driver_id,
                     'vehicle_id' => $vehicle_id,
                     'user_id' => $user_id,
                     'created_at' => $created_at,
                     'updated_at' => $updated_at,
                     'comment'=>$comment,
                     'tax'=>$tax,
                     'date'=>$date__,
                     'num_of_edit'=>DB::raw('num_of_edit + 1'),
                    ]);
        
        ///////////////// action /////////////////
        $new_main = Main::where('id',$main_id)->first();
        $action = "Edit carta num : " . $main_id ;
        Actions::create ( [ 		
            'user' => Auth::user()->name ,
            'action' => $action,
            'comment' => "old main $old_main     ==>   new_main is $new_main"
        ]);

        session()->flash('message', 'Main Fields Updated successfully');
        session()->flash('type', 'success');
       
            
       return redirect ( "/main/edit/$main_id" );
   }


public function main_advancededit_post(Request $request){
    $main_id = $request ['main_id'];
    $quantity = $request ['quantity']; 
    $supplier_id = $request ['supplier_id']; 
    $waste_id = $request ['waste_id'];     // new waste id
    $branch_id = $request ['branch_id'];  // new branch id
    $price = $request ['price'];
    $old_main = Main::where('id',$main_id)->first();
        
    $old_sell_store = $old_main->sell_store;
    if ( $old_sell_store ) {

        $old_sell_store_id = $old_sell_store->id;  
        $old_carta_quantity= $old_main->quantity;

        $new_carta_quantity= $quantity;
        $new_waste = DB::table('waste')->where('id', '=',$waste_id)->first();
        $new_store_id = $new_waste->store_id;
        $new_sell_store = DB::table('store_branch')->where('store_id', '=',$new_store_id)->where('branch_id', '=',$branch_id)->first();
        $new_sell_store_id = $new_sell_store->id;

        if ( $new_sell_store ) {

            // same cell store 
            
            if ( $old_sell_store_id == $new_sell_store_id  ){

                if( $new_carta_quantity > $old_carta_quantity){
                    $diff_quantity = $new_carta_quantity - $old_carta_quantity ;
                    DB::table('store_branch')
                        ->where('id', $old_sell_store_id)
                        ->update([ 'quantity' => DB::raw("quantity+$diff_quantity"),
                                    'updated_at' => Carbon::now()
                    ]);
                    $quantity_before = $old_sell_store->quantity;
                    $quantity_after = $old_sell_store->quantity + $diff_quantity;
                    Store_History::create ( [ 		
                        'quantity_before' => $quantity_before ,
                        'quantity_after' =>  $quantity_after,
                        'descreption' => "Edit Carta num $main_id in The Same Sell_Store_Num $old_sell_store_id  Increase Sell Store by $diff_quantity and  Increase Carta Quantity From $old_carta_quantity   To  $new_carta_quantity",
                        'main_id'  => $main_id,
                        'user_id' => Auth::user()->id,
                        'sell_store_id'=>$old_sell_store_id
                    ] );

                } else if( $new_carta_quantity < $old_carta_quantity){
                    $diff_quantity = $old_carta_quantity - $new_carta_quantity ;
                    
                    DB::table('store_branch')
                        ->where('id', $old_sell_store_id)
                        ->update([ 'quantity' => DB::raw("quantity-$diff_quantity"),
                            'updated_at' => Carbon::now()
                    ]);

                    $Store_History = Store_History::create ( [ 		
                        'quantity_before' => $old_sell_store->quantity,
                        'quantity_after' => ( $old_sell_store->quantity - $diff_quantity ),
                        'descreption' => "Edit Carta num $main_id in The Same Sell_Store_Num $old_sell_store_id  Reduce Sell Store by ( $old_carta_quantity-$new_carta_quantity) , Reduce Carta Quantity From $old_carta_quantity   To  $new_carta_quantity .)",
                        'main_id'  => $main_id,
                        'user_id' => Auth::user()->id,
                        'sell_store_id'=>$old_sell_store_id
                    ] );
                }


                DB::table('mains')
                        ->where('id', $main_id)
                        ->update([
                            'quantity' => $quantity,
                            'supplier_id' => $supplier_id,
                            'waste_id' => $waste_id,
                            'branch_id'=>$branch_id,
                            'price'=>$price,
                ]);

                session()->flash('message', 'Carta Updated Successfully ');
                session()->flash('type', 'success');
            }
            // different sell store
            else if ( $old_sell_store_id != $new_sell_store_id ){
                 
                        // decrease from old sell_store
                    DB::table('store_branch')
                        ->where('id', $old_sell_store_id)
                        ->update([ 'quantity' => DB::raw("quantity-$old_carta_quantity"),
                                'updated_at' => Carbon::now()
                    ]);

                    // increase in new sell store
                    DB::table('store_branch')
                        ->where('id', $new_sell_store_id)
                        ->update([ 'quantity' => DB::raw("quantity+$new_carta_quantity"),
                                'updated_at' => Carbon::now()
                    ]);

                    DB::table('mains')
                            ->where('id', $main_id)
                            ->update([
                                'quantity' => $quantity,
                                'supplier_id' => $supplier_id,
                                'waste_id' => $waste_id,
                                'branch_id'=>$branch_id,
                                'price'=>$price,
                                'sell_store_id' => $new_sell_store_id
                    ]);

                    // Increase   the decrease in one query
                    Store_History::insert ( 
                        [ 		
                            'quantity_before' => $old_sell_store->quantity,
                            'quantity_after' =>  $old_sell_store->quantity - $old_carta_quantity ,
                            'descreption' => "Edit Carta num $main_id in Old Sell_Store_Num $old_sell_store_id  Decrease sell_store by  $old_carta_quantity )",
                            'main_id'  => $main_id,
                            'user_id' => Auth::user()->id,
                            'sell_store_id'=>$old_sell_store_id
                        ]);
                        Store_History::insert ( 
                        [		
                            'quantity_before' => $new_sell_store->quantity,
                            'quantity_after' => ( $new_sell_store->quantity + $new_carta_quantity ),
                            'descreption' => "Edit Carta num $main_id in New Sell_Store_Num $old_sell_store_id  Increase sell_store by $new_carta_quantity )",
                            'main_id'  => $main_id,
                            'user_id' => Auth::user()->id,
                            'sell_store_id'=>$new_sell_store_id
                        ]  
                    );

            } 

        }else{

        session()->flash('message', 'Carta not changed , No Target Sell store found ');
        session()->flash('type', 'success');
    }

    }else{

    
// check again if any one tie new carta with sell store
        $store_id = $old_main->waste->store_id;
        if ( $store_id ) {
            $sell_store = DB::table('store_branch')->where('store_id', '=',$store_id)->where('branch_id', '=',$branch_id)->first();
            if($sell_store){
            $sell_store_id = $sell_store->id ;
            $sell_store_quantity = $sell_store->quantity;
                    DB::table('store_branch')
                        ->where('id', $sell_store_id)
                        ->update([ 'quantity' => DB::raw("quantity+$quantity"),
                                'updated_at' => Carbon::now()
                    ]);

                    DB::table('mains')
                            ->where('id', $main_id)
                            ->update([
                                'quantity' => $quantity,
                                'supplier_id' => $supplier_id,
                                'waste_id' => $waste_id,
                                'branch_id'=>$branch_id,
                                'price'=>$price,
                                'sell_store_id' => $sell_store_id
                    ]);
                    Store_History::insert (
                        [		
                            'quantity_before' => $sell_store_quantity,
                            'quantity_after' => ( $sell_store_quantity + $quantity ),
                            'descreption' => "Edit Carta num $main_id in New Sell_Store_Num $sell_store_id  Increase sell_store by $quantity )",
                            'main_id'  => $main_id,
                            'user_id' => Auth::user()->id,
                            'sell_store_id'=>$sell_store_id
                        ]  
                    );
            }else{
                
                DB::table('mains')
                            ->where('id', $main_id)
                            ->update([
                                'quantity' => $quantity,
                                'supplier_id' => $supplier_id,
                                'waste_id' => $waste_id,
                                'branch_id'=>$branch_id,
                                'price'=>$price
                    ]);
                    
                session()->flash('message', 'No Sell store, Please Provide sell Store ');
                session()->flash('type', 'success');
            }
        }else{
            
            DB::table('mains')
                            ->where('id', $main_id)
                            ->update([
                                'quantity' => $quantity,
                                'supplier_id' => $supplier_id,
                                'waste_id' => $waste_id,
                                'branch_id'=>$branch_id,
                                'price'=>$price,
                                'num_of_edit' => DB::raw("num_of_edit+1"),
                            ]);
                            
        }

    }

  

   return redirect ( "main/advancededit/$main_id" );
}
   ////////////////////////////////



///
    public function main_add_get(){

        $suppliers = Supplier::get();
        $packingmethods = Packingmethod::get();
        $drivers = Driver::get();
        $physicalconditions = Physicalcondition::get();
        $vehicles = Vehicle::get();
        $branchs = Branch::get();
        $users = DB::table('users')->where('is_supervisor', '!=',NULL)->get();
        
        
        $customers = Customer::get();
        $datetime = date('Y-m-d H:i:s');
        $cenvertedTime = date('Y-m-d H:i:s',strtotime('+15 minutes',strtotime($datetime)));
        
        
        //sleep(4);
        return view('mainadd',[
                'suppliers' => $suppliers,
                'packingmethods' => $packingmethods,
                'drivers' => $drivers,
                'physicalconditions' => $physicalconditions,
                'vehicles' => $vehicles,
                'users' => $users,
                'branchs'=>$branchs,
                'customers'=>$customers,
                'datetime'=>$datetime,
                'cenvertedTime'=>$cenvertedTime,
                'wastes'=>[] 
        ]);
        
    }


    public function main_add_post(Request $request){
        $quantity = $request ['quantity']; 
        $supplier_id = $request ['supplier_id']; 
        $waste_id = $request ['waste_id']; 
        $packingmethod_id = $request ['packingmethod_id']; 
        $physicalcondition_id = $request ['physicalcondition_id']; 
        $driver_id = $request ['driver_id'];
        $vehicle_id = $request ['vehicle_id'];
        $user_id = $request ['user_id'];
        $branch_id = $request ['branch_id'];
        

        $waste_details  = Waste::where('id',$waste_id)->first();
         
        $price = $waste_details->price;
        $tax = $waste_details->tax;
         
        //echo $branch_id . "  ". $price . "  " . $tax;
        //return 0;
        
        
        
        
        $created_at = $request ['created_at'];
        $updated_at = $request ['updated_at'];
        $comment = $request ['comment'];
        $approved = $request ['approved'];
        $customer_id = $request ['customer_id'];
        $approve_admin_id = NULL ;
        $sent_to_recy_admin_id = NULL;
        $sql_approve = NULL ;
        $created_at_final = new \DateTime($created_at);  // will insert in all cases 


        if( $approved == "approved") {
            $approve_admin_id =Auth::user()->id;
            $sql_approve = "approved";
            $updated_at_final =  new \DateTime($updated_at);
        }else{ 
            $approve_admin_id = NULL ;
            $sql_approve = NULL;
            $updated_at_final = NULL; 
        }
        if ($customer_id != "-1" ) { 
            $sent_to_recy_admin_id = Auth::user()->id; 
        }else{
            $sent_to_recy_admin_id = NULL;
            $customer_id = NULL;
        }

       // $current_date_time = new \DateTime('NOW');
        $current_date_time = new \DateTime($created_at);
        $date__ = $current_date_time->format("Y-m-d");

        //echo $date;
        
        
        
        
     
        
        $main = Main::create ( [ 		
            'quantity' => $quantity,
            'supplier_id' => $supplier_id,
            'waste_id' => $waste_id,
            'packingmethod_id' => $packingmethod_id,
            'physicalcondition_id' => $physicalcondition_id,
            'driver_id' => $driver_id,
            'vehicle_id' => $vehicle_id,
            'user_id' => $user_id,
            'branch_id' => $branch_id,
            'price'=>$price,
            'tax'=>$tax,
            'created_at'=>$created_at_final,
            'updated_at'=>$updated_at_final,
            'admin_id'=>$approve_admin_id,
            'approve'=>$sql_approve,
            'sent_to_recy_admin_id'=>$sent_to_recy_admin_id,
            "customer_id"=>$customer_id,
            'comment'=>$comment,
            'date'=>$date__,
        ] );  
                    
       session()->flash('message', 'Main Fields Added successfully');
       session()->flash('type', 'success');
   
   
   
    ///////////////// action /////////////////
        
       $action = "Add carta num : " . $main->id ;
       Actions::create ( [ 		
        'user' => Auth::user()->name ,
        'action' => $action,
        'comment' => "Add New Carta"
            ] );
        /////////////////////////////////
        
        
    // increment store ////////////////////////
    // main ==> waste ==> store   ==> get strore
    $store = $main->waste->store;  // may be waste not connected by store so check on store 
    if ($store) {
        $store_id = $store->id;
        // get specific sell store to increment it 
        $sell_store = DB::table('store_branch')->where('store_id', '=',$store_id)->where('branch_id', '=',$branch_id)->first();
        // check if there is sell store
        if($sell_store) {
            DB::table('store_branch')
                    ->where('store_id', $store_id)
                    ->where('branch_id', $branch_id)
                    ->where('id','=',$sell_store->id)
                    ->update([ 'quantity' => DB::raw("quantity+$quantity"),
                        'updated_at' => Carbon::now()]
            );
        
            DB::table('mains')
                    ->where('id', $main->id)
                    ->update([ 'sell_store_id' => $sell_store->id]
            );

            $Store_History = Store_History::create ( [ 		
                'quantity_before' => $sell_store->quantity,
                'quantity_after' => ( $sell_store->quantity + $quantity ),
                'descreption' => "Create new web carta num ".$main->id ." quantity ( $quantity )",
                'main_id'  => $main->id,
                'user_id' => Auth::user()->id,
                'sell_store_id'=>$sell_store->id
            ] ); 

        }
    }
    
        /////////////////////////////////
        
        
        
       return redirect ( "/" );
       
       
   }
///

    public function change_customer_edit_get($main_id){
        $main = Main::where('id',$main_id)->first();
        $customers = Customer::get();
      

        return view('changecustomer',[
                'main' => $main, 
                'customers'=>$customers,
         ]);
        
    }

    public function change_customer_edit_post( Request $request){
      
        $admin_id= Auth::user()->id;
        $main_id = $request ['main_id'];
        $customer_id = $request ['customer_id'];
        DB::table('mains')
            ->where('id', $main_id)
            ->update(['customer_id' => $customer_id , 'sent_to_recy_admin_id'=>$admin_id]);
		        
        session()->flash('message', 'Customer Changed successfully');
        session()->flash('type', 'success');



 ///////////////// action /////////////////
        $customer = DB::table('customers')->where('id', '=',$customer_id)->first();
        $n = $customer->name;
         var_dump ($n ) ;
        $action = "Send to recycler "  ;
        Actions::create ( [ 		
        'user' => Auth::user()->name ,
        'action' => $action,
        'comment' => "carta $main_id has been sent to $n "
        ] );
        ///////////////////
        
        return redirect ("/home");


        
    }



    public function main_approve($waste_id){
        
       /* DB::table('mains')
          ->where('id', $waste_id)
          ->update(['approve' => "approved", 'updated_at' => Carbon::now()]);
              
        return redirect ("/home");
        */
         
         $admin_id= Auth::user()->id;

        DB::table('mains')
          ->where('id', $waste_id)
          ->update(['approve' => "approved",'admin_id' => $admin_id , 'updated_at' => Carbon::now()]);
              
       // return redirect ("/home");
        return redirect()->back();
        
    }

 public function main_delete($main_id){
          
        $main = Main::find($main_id);
        $main->delete();
        
           ///////////////// action /////////////////
        
       $action = "Delete carta num : " .  $main_id ; 
       Actions::create ( [ 		
        'user' => Auth::user()->name ,
        'action' => $action,
        'comment' => "Delete  Carta $main"
            ] );
        /////////////////////////////////
        
        $quantity = $main->quantity;
        $sell_store = $main->sell_store;
        $sell_store_id = $sell_store->id;

        DB::table('store_branch')
        ->where('id', $sell_store_id)
        ->update([ 'quantity' => DB::raw("quantity-$quantity"),
                'updated_at' => Carbon::now()
        ]);

        Store_History::insert ( 
            [ 		
                'quantity_before' => $sell_store->quantity,
                'quantity_after' =>  $sell_store->quantity - $quantity ,
                'descreption' => "Delete Carta num $main_id in Old Sell_Store_Num $sell_store_id  Decrease sell_store by  $quantity )",
                'main_id'  => $main_id,
                'user_id' => Auth::user()->id,
                'sell_store_id'=>$sell_store_id
            ]);
        
        return redirect ( "/home");
    }
    
    // ajax 
    public function main_get_waste_supplier($supplier_id){
        
        $supplier = Supplier::find($supplier_id);	
        $wastes_ = $supplier->waste;

        return \Response::json ( [ 
				'wastes_' => $wastes_ 
		] ); 


    }
    
      public function getPrice($waste_id){
        $waste = Waste::find($waste_id);	
        $price = $waste["price"];
        return $price;
    }
    
    
    
    
       public function sent_to_multi_customer (Request $request)
   {
       
       $main_ids =  $request ['checked'];
       $customers = Customer::get(); 
       return view('changemulticustomer',[
        'main_ids' => $main_ids, 
        'customers'=>$customers,
        ]);
      
   }
   public function change_multi_customer_edit_post( Request $request){
    $admin_id= Auth::user()->id;
    $customer_id = $request ['customer_id'];
    $data = $request->except(['_token', 'customer_id']);
    $waste_ids=[];
    foreach ($data as $key => $value) {
            $waste_ids[] =  $value;
    }
    
   $customer_id = $request ['customer_id'];
    DB::table('mains')
        ->whereIn('id', $waste_ids)
        ->update(['customer_id' => $customer_id , 'sent_to_recy_admin_id'=>$admin_id ]);
            
    return redirect ("/home");
}



     public function notfound()
    {
        return view('404' );
    }
    
    
}
