
<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/
/*
Route::get('/', function () {
    return view('welcome');
});

Route::auth();

Route::get('/home', 'HomeController@index');
*/



Route::auth();

//Route::get('/', 'HomeController@index');
Route::get('/', 'HomeController@index')->middleware('is_not_supplier');
Route::get('/actions', 'HomeController@actions');

Route::get('/home', 'HomeController@index');
Route::get('/main/not_approved', 'HomeController@not_approved');
Route::post('/main/not_sent_to_customer', 'HomeController@not_sent_to_customer');
Route::post('/main/sent_to_customer', 'HomeController@sent_to_customer');
Route::get('/main/group_charts', 'HomeController@group_charts');

Route::get('/main/advancededit/get_price/{waste_id}', 'HomeController@getPrice');

Route::get('/main/edit/{main_id}', 'HomeController@main_edit_get')->where('main_id', '[0-9]+');


Route::post('/main/edit', 'HomeController@main_edit_post');
Route::get('/main/approve/{waste_id}', 'HomeController@main_approve')->where('waste_id', '[0-9]+');
Route::get('main/advancededit/ajax/{supplier_id}', 'HomeController@main_get_waste_supplier');
Route::get('/main/changecustomer/{main_id}', 'HomeController@change_customer_edit_get')->where('main_id', '[0-9]+');
Route::post('/main/changecustomer', 'HomeController@change_customer_edit_post');
Route::get('/main/delete/{main_id}', 'HomeController@main_delete')->where('main_id', '[0-9]+');



// add carta
Route::get('/main/add', 'HomeController@main_add_get');
Route::post('/main/add', 'HomeController@main_add_post');
Route::get('main/ajax/{supplier_id}', 'HomeController@main_get_waste_supplier');

//send to multi customer 
Route::post('/main/sent_to_multi_customer', 'HomeController@sent_to_multi_customer');
Route::post('/main/change_to_multi_customer', 'HomeController@change_multi_customer_edit_post');



Route::get('/class/index', 'WasteController@class_show');
Route::get('/class/create', 'WasteController@class_create_get');
Route::post('/class/create', 'WasteController@class_create');
Route::get('/class/edit/{class_id}', 'WasteController@class_edit_get')->where('class_id', '[0-9]+');
Route::post('/class/edit', 'WasteController@class_edit_post');
Route::get('/class/delete/{class_id}', 'WasteController@class_delete')->where('class_id', '[0-9]+');

Route::get('/classification/index', 'WasteController@classification_show');
Route::get('/classification/create', 'WasteController@classification_create_get');
Route::post('/classification/create', 'WasteController@classification_create');
Route::get('/classification/edit/{classification_id}', 'WasteController@classification_edit_get')->where('classification_id', '[0-9]+');
Route::post('/classification/edit', 'WasteController@classification_edit_post');
Route::get('/classification/delete/{classification_id}', 'WasteController@classification_delete')->where('classification_id', '[0-9]+');

Route::get('/group/index', 'WasteController@group_show');
Route::get('/group/create', 'WasteController@group_create_get');
Route::post('/group/create', 'WasteController@group_create');
Route::get('/group/edit/{group_id}', 'WasteController@group_edit_get')->where('group_id', '[0-9]+');
Route::post('/group/edit', 'WasteController@group_edit_post');
Route::get('/group/delete/{group_id}', 'WasteController@group_delete')->where('group_id', '[0-9]+');


Route::get('/transporter/index', 'WasteController@transporter_show');
Route::get('/transporter/create', 'WasteController@transporter_create_get');
Route::post('/transporter/create', 'WasteController@transporter_create');
Route::get('/transporter/edit/{transporter_id}', 'WasteController@transporter_edit_get')->where('transporter_id', '[0-9]+');
Route::post('/transporter/edit', 'WasteController@transporter_edit_post');
Route::get('/transporter/delete/{transporter_id}', 'WasteController@transporter_delete')->where('transporter_id', '[0-9]+');



Route::get('/recycle_method/index', 'WasteController@recycle_method_show');
Route::get('/recycle_method/create', 'WasteController@recycle_method_create_get');
Route::post('/recycle_method/create', 'WasteController@recycle_method_create');
Route::get('/recycle_method/edit/{recycle_method_id}', 'WasteController@recycle_method_edit_get')->where('recycle_method_id', '[0-9]+');
Route::post('/recycle_method/edit', 'WasteController@recycle_method_edit_post');
Route::get('/recycle_method/delete/{recycle_method_id}', 'WasteController@recycle_method_delete')->where('recycle_method_id', '[0-9]+');


Route::get('/waste/index', 'WasteController@waste_show');
Route::get('/waste/create', 'WasteController@waste_create_get');
Route::post('/waste/create', 'WasteController@waste_create');
Route::get('/waste/edit/{waste_id}', 'WasteController@waste_edit_get')->where('waste_id', '[0-9]+');
Route::post('/waste/edit', 'WasteController@waste_edit_post');
Route::get('/waste/delete/{waste_id}', 'WasteController@waste_delete')->where('waste_id', '[0-9]+');


Route::get('/supplier/index', 'SupplierController@supplier_show');
Route::get('/supplier/create', 'SupplierController@supplier_create_get');
Route::post('/supplier/create', 'SupplierController@supplier_create');
Route::get('/supplier/edit/{supplier_id}', 'SupplierController@supplier_edit_get')->where('supplier_id', '[0-9]+');
Route::post('/supplier/edit', 'SupplierController@supplier_edit_post');
Route::get('/supplier/delete/{supplier_id}', 'SupplierController@supplier_delete')->where('supplier_id', '[0-9]+');
Route::get('/waste_supplier/create', 'SupplierController@waste_supplier_create_get');
Route::post('/waste_supplier/create', 'SupplierController@waste_supplier_create');

Route::get('/suppervisor_supplier_list/edit/{user_id}', 'SupplierController@suppervisor_supplier_list_get');
Route::post('/suppervisor_supplier_list/edit', 'SupplierController@suppervisor_supplier_list_edit');


Route::get('/driver/index', 'DriverController@driver_show');
Route::get('/driver/create', 'DriverController@driver_create_get');
Route::post('/driver/create', 'DriverController@driver_create');
Route::get('/driver/edit/{driver_id}', 'DriverController@driver_edit_get')->where('driver_id', '[0-9]+');
Route::post('/driver/edit', 'DriverController@driver_edit_post');
Route::get('/driver/delete/{driver_id}', 'DriverController@driver_delete')->where('driver_id', '[0-9]+');


Route::get('/vehicle/index', 'DriverController@vehicle_show');
Route::get('/vehicle/create', 'DriverController@vehicle_create_get');
Route::post('/vehicle/create', 'DriverController@vehicle_create');
Route::get('/vehicle/edit/{vehicle_id}', 'DriverController@vehicle_edit_get')->where('vehicle_id', '[0-9]+');
Route::post('/vehicle/edit', 'DriverController@vehicle_edit_post');
Route::get('/vehicle/delete/{vehicle_id}', 'DriverController@vehicle_delete')->where('vehicle_id', '[0-9]+');


Route::get('/branch/index', 'BranchController@branch_show');
Route::get('/branch/create', 'BranchController@branch_create_get');
Route::post('/branch/create', 'BranchController@branch_create');
Route::get('/branch/edit/{branch_id}', 'BranchController@branch_edit_get')->where('branch_id', '[0-9]+');
Route::post('/branch/edit', 'BranchController@branch_edit_post');
Route::get('/branch/delete/{branch_id}', 'BranchController@branch_delete')->where('branch_id', '[0-9]+');

Route::get('/message/index', 'MessageController@message_show');
Route::get('/message/create', 'MessageController@message_create_get');
Route::post('/message/create', 'MessageController@message_create');
Route::get('/message/edit/{message_id}', 'MessageController@message_edit_get')->where('message_id', '[0-9]+');
Route::post('/message/edit', 'MessageController@message_edit_post');
Route::get('/message/delete/{message_id}', 'MessageController@message_delete')->where('message_id', '[0-9]+');



Route::get('/permit/index', 'DriverController@permit_show');
Route::get('/permit/create', 'DriverController@permit_create_get');
Route::post('/permit/create', 'DriverController@permit_create');
Route::get('/permit/edit/{permit_id}', 'DriverController@permit_edit_get')->where('permit_id', '[0-9]+');
Route::post('/permit/edit', 'DriverController@permit_edit_post');
Route::get('/permit/delete/{permit_id}', 'DriverController@permit_delete')->where('permit_id', '[0-9]+');


Route::get('/city/index', 'SupplierController@city_show');
Route::get('/city/create', 'SupplierController@city_create_get');
Route::post('/city/create', 'SupplierController@city_create');
Route::get('/city/edit/{city_id}', 'SupplierController@city_edit_get')->where('city_id', '[0-9]+');
Route::post('/city/edit', 'SupplierController@city_edit_post');
Route::get('/city/delete/{city_id}', 'SupplierController@city_delete')->where('city_id', '[0-9]+');

Route::get('/user/index', 'SupplierController@user_show');
Route::get('/user/create', 'SupplierController@user_create_get');
Route::post('/user/create', 'SupplierController@user_create');
Route::get('/user/edit/{user_id}', 'SupplierController@user_edit_get')->where('user_id', '[0-9]+');
Route::post('/user/edit', 'SupplierController@user_edit_post');
Route::get('/user/delete/{user_id}', 'SupplierController@user_delete')->where('user_id', '[0-9]+');

Route::get('/credential/create', 'SupplierController@credential_create_get');
Route::post('/credential/create', 'SupplierController@credential_create');
Route::get('/credential/edit/{user_id}', 'SupplierController@credential_edit_get')->where('user_id', '[0-9]+');
Route::post('/credential/edit', 'SupplierController@credential_edit_post');


Route::get('/activity/index', 'SupplierController@activity_show');
Route::get('/activity/create', 'SupplierController@activity_create_get');
Route::post('/activity/create', 'SupplierController@activity_create');
Route::get('/activity/edit/{activity_id}', 'SupplierController@activity_edit_get')->where('activity_id', '[0-9]+');
Route::post('/activity/edit', 'SupplierController@activity_edit_post');
Route::get('/activity/delete/{activity_id}', 'SupplierController@activity_delete')->where('activity_id', '[0-9]+');
Route::get('/activity_supplier/create', 'SupplierController@activity_supplier_create_get');
Route::post('/activity_supplier/create', 'SupplierController@activity_supplier_create');




Route::get('/packingmethod/index', 'WasteController@packingmethod_show');
Route::get('/packingmethod/create', 'WasteController@packingmethod_create_get');
Route::post('/packingmethod/create', 'WasteController@packingmethod_create');
Route::get('/packingmethod/edit/{packingmethod_id}', 'WasteController@packingmethod_edit_get')->where('packingmethod_id', '[0-9]+');
Route::post('/packingmethod/edit', 'WasteController@packingmethod_edit_post');
Route::get('/packingmethod/delete/{packingmethod_id}', 'WasteController@packingmethod_delete')->where('packingmethod_id', '[0-9]+');

Route::get('/physicalcondition/index', 'WasteController@physicalcondition_show');
Route::get('/physicalcondition/create', 'WasteController@physicalcondition_create_get');
Route::post('/physicalcondition/create', 'WasteController@physicalcondition_create');
Route::get('/physicalcondition/edit/{physicalcondition_id}', 'WasteController@physicalcondition_edit_get')->where('physicalcondition_id', '[0-9]+');
Route::post('/physicalcondition/edit', 'WasteController@physicalcondition_edit_post');
Route::get('/physicalcondition/delete/{physicalcondition_id}', 'WasteController@physicalcondition_delete')->where('physicalcondition_id', '[0-9]+');


Route::get('/customer/index', 'CustomerController@customer_show');
Route::get('/customer/create', 'CustomerController@customer_create_get');
Route::post('/customer/create', 'CustomerController@customer_create');
Route::get('/customer/edit/{customer_id}', 'CustomerController@customer_edit_get')->where('customer_id', '[0-9]+');
Route::post('/customer/edit', 'CustomerController@customer_edit_post');
Route::get('/customer/delete/{customer_id}', 'CustomerController@customer_delete')->where('customer_id', '[0-9]+');



Route::get('/price/index', 'PriceController@price_show');
Route::get('/price/edit_get', 'PriceController@price_edit_get');
Route::post('/price/edit', 'PriceController@price_edit_post');



Route::get('/report/create', 'ReportController@report_create');

Route::get('/report/create/ajaxsuppliers/{from}/{to}', 'ReportController@get_suppliers');

Route::get('/report/create/ajaxclass/{supplier_id}/{from}/{to}', 'ReportController@get_class');
Route::get('/report/create/ajaxgroup/{class_id}', 'ReportController@get_group');
Route::get('/report/create/ajaxclassification/{group_id}', 'ReportController@get_classification');

Route::get('/report/create/ajaxcustomers/{classification_id}', 'ReportController@get_customers');

Route::post('/report/create', 'ReportController@report_create_post');




// recycler reports 
Route::get('/recycler_report/create', 'RecyclerReportController@report_create');
Route::get('/recycler_report/create/get_customers/{from}/{to}', 'RecyclerReportController@get_customers');
Route::get('/recycler_report/create/show_suppliers/{customer_id}/{from}/{to}', 'RecyclerReportController@get_suppliers');
Route::get('/recycler_report/create/show_wastes/{arr_of_suppliers}/{customer_id}/{from}/{to}', 'RecyclerReportController@get_wastes');
Route::post('/recycler_report/create', 'RecyclerReportController@recycler_report_create_post');

// class reports 
Route::get('/class_report/create', 'ClassReportController@report_create');
Route::get('/class_report/create/ajaxclass_wastes/{from}/{to}', 'ClassReportController@get_wastes');
Route::get('/class_report/create/ajaxclass_suppliers/{arr_of_wastes}/{from}/{to}', 'ClassReportController@get_suppliers');
Route::post('/class_report/create', 'ClassReportController@class_report_create_post');

// group reports 
Route::get('/group_report/create', 'GroupReportController@report_create');
Route::get('/group_report/create/get_groups/{from}/{to}', 'GroupReportController@get_groups');
Route::get('/group_report/create/ajaxgroup_suppliers/{arr_of_groups}/{from}/{to}', 'GroupReportController@get_suppliers');
Route::post('/group_report/create', 'GroupReportController@group_report_create_post');

// invoice reports 
Route::get('/invoice_report/create', 'InvoiceReportController@report_create');
Route::get('/invoice_report/create/get_suppliers/{from}/{to}', 'InvoiceReportController@get_suppliers');
Route::get('/invoice_report/create/get_classes/{supplier_id}/{from}/{to}', 'InvoiceReportController@get_classes');
Route::post('/invoice_report/create', 'InvoiceReportController@invoice_report_create_post');



// chart reports 
Route::get('/chart_report/create', 'ChartReportController@report_create');
Route::get('/chart_report/create/get_suppliers/{from}/{to}', 'ChartReportController@get_suppliers');
Route::get('/chart_report/create/get_classes/{supplier_id}/{from}/{to}', 'ChartReportController@get_classes');
Route::get('/chart_report/create/get_groups/{supplier_id}/{class_id}/{from}/{to}', 'ChartReportController@get_groups');
Route::get('/chart_report/create/get_classifications/{supplier_id}/{class_id}/{group_id}/{from}/{to}', 'ChartReportController@get_classifications');
Route::get('/chart_report/create/draw/{supplier_id}/{class_id}/{group_id}/{classification_id}/{from}/{to}', 'ChartReportController@draw');


// driver reports 
Route::get('/driver_report/create', 'DriverReportController@driver_report_create_get');
Route::get('/driver_report/create/get_drivers/{from}/{to}', 'DriverReportController@get_drivers');
Route::post('/driver_report/create', 'DriverReportController@driver_report_create_post');

// vehicle reports 
Route::get('/vehicle_report/create', 'DriverReportController@vehicle_report_create_get');
Route::get('/vehicle_report/create/get_vehicles/{from}/{to}', 'DriverReportController@get_vehicles');
Route::post('/vehicle_report/create', 'DriverReportController@vehicle_report_create_post');

/// stores

Route::get('/store/index', 'BranchController@store_show');
Route::get('/store/create', 'BranchController@store_create_get');
Route::post('/store/create', 'BranchController@store_create');
Route::get('/store/edit/{store_id}', 'BranchController@store_edit_get')->where('store_id', '[0-9]+');
Route::post('/store/edit', 'BranchController@store_edit_post');
Route::get('/store/delete/{store_id}', 'BranchController@store_delete')->where('store_id', '[0-9]+');

//sell store

Route::get('/store/branch/edit/{store_branch_id}', 'BranchController@store_branch_edit_get');
Route::post('/store/branch/edit', 'BranchController@store_branch_edit_post');

Route::get('/store/branch/create', 'BranchController@store_branch_create_get');
Route::post('/store/branch/create', 'BranchController@store_branch_create_post');
Route::get('/store/branch/index', 'BranchController@store_branch_show');

// advanced edit
Route::get('/main/advancededit/{main_id}', 'HomeController@main_advancededit_get')->where('main_id', '[0-9]+');
Route::post('/main/advancededit', 'HomeController@main_advancededit_post');


Route::any('{catchall}', 'HomeController@notfound')->where('catchall', '.*');

