<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Store_History extends Model
{
    public $timestamps = true;
    protected $table = 'store_history';
    protected $fillable = [
       'quantity_before','quantity_after','descreption','main_id','created_at','updated_at','user_id','sell_store_id'
    ];


    public function store()
    {
        return $this->belongsTo('App\Store', 'store_id');
    }
    public function main()
    {
        return $this->belongsTo('App\Main', 'main_id');
    }
    public function user()
    {
        return $this->belongsTo('App\User', 'user_id');
    }
}

